/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

@MissingNullInOutFunction
public class CodePointToStringDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = CodePointToStringDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IScalarEvaluatorFactory listEvalFactory;
                    private final IPointable inputArgList;
                    private final IScalarEvaluator evalList;
                    private final byte[] currentUTF8;
                    private final byte[] tempStoreForLength;
                    private final FunctionIdentifier fid;
                    private final char[] tempCharPair;
                    {
                        this.listEvalFactory = args[0];
                        this.inputArgList = new VoidPointable();
                        this.evalList = this.listEvalFactory.createScalarEvaluator(ctx);
                        this.currentUTF8 = new byte[6];
                        this.tempStoreForLength = new byte[5];
                        this.fid = CodePointToStringDescriptor.this.getIdentifier();
                        this.tempCharPair = new char[2];
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        try {
                            int codePoint;
                            int itemOffset;
                            int i;
                            int offset;
                            this.resultStorage.reset();
                            Arrays.fill(this.tempStoreForLength, (byte)0);
                            Arrays.fill(this.currentUTF8, (byte)0);
                            this.evalList.evaluate(tuple, this.inputArgList);
                            if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArgList)) {
                                return;
                            }
                            byte[] serOrderedList = this.inputArgList.getByteArray();
                            if (serOrderedList[offset = this.inputArgList.getStartOffset()] != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
                                PointableHelper.setNull(result);
                                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)CodePointToStringDescriptor.this.sourceLoc, (FunctionIdentifier)this.fid, (byte)serOrderedList[offset], (int)0, (ATypeTag)ATypeTag.ARRAY);
                                return;
                            }
                            int itemTagPosition = offset + 1;
                            ATypeTag itemTag = ATypeTag.VALUE_TYPE_MAPPING[serOrderedList[itemTagPosition]];
                            boolean isItemTagged = itemTag == ATypeTag.ANY;
                            int size = AOrderedListSerializerDeserializer.getNumberOfItems((byte[])serOrderedList, (int)offset);
                            int utf_8_len = 0;
                            boolean returnNull = false;
                            ATypeTag invalidTag = null;
                            for (i = 0; i < size; ++i) {
                                itemOffset = AOrderedListSerializerDeserializer.getItemOffset((byte[])serOrderedList, (int)offset, (int)i);
                                if (isItemTagged) {
                                    itemTag = ATypeTag.VALUE_TYPE_MAPPING[serOrderedList[itemOffset]];
                                    itemTagPosition = itemOffset++;
                                }
                                if (itemTag == ATypeTag.MISSING) {
                                    PointableHelper.setMissing(result);
                                    return;
                                }
                                if (itemTag == ATypeTag.NULL) {
                                    returnNull = true;
                                    invalidTag = null;
                                } else if (!returnNull && !ATypeHierarchy.canPromote((ATypeTag)itemTag, (ATypeTag)ATypeTag.BIGINT)) {
                                    returnNull = true;
                                    invalidTag = itemTag;
                                }
                                if (returnNull) continue;
                                codePoint = ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition((String)this.fid.getName(), (int)0, (byte[])serOrderedList, (int)itemOffset, (int)itemTagPosition);
                                utf_8_len += UTF8StringUtil.codePointToUTF8((int)codePoint, (char[])this.tempCharPair, (byte[])this.currentUTF8);
                            }
                            if (returnNull) {
                                PointableHelper.setNull(result);
                                if (invalidTag != null) {
                                    ExceptionUtil.warnUnsupportedType((IEvaluatorContext)ctx, (SourceLocation)CodePointToStringDescriptor.this.sourceLoc, (String)this.fid.getName(), invalidTag);
                                }
                                return;
                            }
                            this.out.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            UTF8StringUtil.writeUTF8Length((int)utf_8_len, (byte[])this.tempStoreForLength, (DataOutput)this.out);
                            for (i = 0; i < size; ++i) {
                                itemOffset = AOrderedListSerializerDeserializer.getItemOffset((byte[])serOrderedList, (int)offset, (int)i);
                                if (isItemTagged) {
                                    itemTagPosition = itemOffset++;
                                }
                                codePoint = ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition((String)this.fid.getName(), (int)0, (byte[])serOrderedList, (int)itemOffset, (int)itemTagPosition);
                                utf_8_len = UTF8StringUtil.codePointToUTF8((int)codePoint, (char[])this.tempCharPair, (byte[])this.currentUTF8);
                                for (int j = 0; j < utf_8_len; ++j) {
                                    this.out.writeByte(this.currentUTF8[j]);
                                }
                            }
                            result.set((IValueReference)this.resultStorage);
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.CODEPOINT_TO_STRING;
    }
}

