/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.ContentFile;
import org.apache.iceberg.PartitionScanTask;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Expression;

public interface ContentScanTask<F extends ContentFile<F>>
extends ScanTask,
PartitionScanTask {
    public F file();

    @Override
    default public StructLike partition() {
        return this.file().partition();
    }

    public long start();

    public long length();

    public Expression residual();

    @Override
    default public long estimatedRowsCount() {
        long splitOffset = this.file().splitOffsets() != null ? this.file().splitOffsets().get(0) : 0L;
        double scannedFileFraction = (double)this.length() / (double)(this.file().fileSizeInBytes() - splitOffset);
        return (long)(scannedFileFraction * (double)this.file().recordCount());
    }
}

