/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.app.function.FunctionRewriter;
import org.apache.asterix.app.function.QueryIndexDatasource;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionConstants;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.FunctionDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.ISecondaryIndexOperationsHelper;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.metadata.utils.SecondaryIndexOperationsHelper;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.util.LogRedactionUtil;

public class QueryIndexRewriter
extends FunctionRewriter
implements IResultTypeComputer {
    public static final FunctionIdentifier QUERY_INDEX = FunctionConstants.newAsterix((String)"query-index", (int)-1);
    public static final QueryIndexRewriter INSTANCE = new QueryIndexRewriter(QUERY_INDEX);

    private QueryIndexRewriter(FunctionIdentifier functionId) {
        super(functionId);
    }

    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> mp) throws AlgebricksException {
        return this.computeRecType((AbstractFunctionCallExpression)expression, (MetadataProvider)mp, null, null, null);
    }

    @Override
    public FunctionDataSource toDatasource(IOptimizationContext ctx, AbstractFunctionCallExpression f) throws AlgebricksException {
        SourceLocation loc = f.getSourceLocation();
        DataverseName dvName = this.getDataverseName(loc, f.getArguments(), 0);
        String dsName = this.getString(loc, f.getArguments(), 1);
        String idName = this.getString(loc, f.getArguments(), 2);
        String dbName = f.getArguments().size() > 3 ? this.getString(loc, f.getArguments(), 3) : MetadataUtil.databaseFor((DataverseName)dvName);
        MetadataProvider mp = (MetadataProvider)ctx.getMetadataProvider();
        Dataset dataset = QueryIndexRewriter.validateDataset(mp, dbName, dvName, dsName, loc);
        Index index = QueryIndexRewriter.validateIndex(f, mp, loc, dbName, dvName, dsName, idName);
        return this.createQueryIndexDatasource(mp, dataset, index, loc, f);
    }

    @Override
    protected void createDataScanOp(Mutable<ILogicalOperator> opRef, UnnestOperator unnest, IOptimizationContext ctx, AbstractFunctionCallExpression f) throws AlgebricksException {
        FunctionDataSource datasource = this.toDatasource(ctx, f);
        ArrayList<LogicalVariable> variables = new ArrayList<LogicalVariable>();
        ArrayList<Mutable<ILogicalExpression>> closedRecArgs = new ArrayList<Mutable<ILogicalExpression>>();
        MetadataProvider mp = (MetadataProvider)ctx.getMetadataProvider();
        this.computeRecType(f, mp, variables, closedRecArgs, ctx);
        DataSourceScanOperator scan = new DataSourceScanOperator(variables, (IDataSource)datasource);
        scan.setSourceLocation(unnest.getSourceLocation());
        List scanInpList = scan.getInputs();
        scanInpList.addAll(unnest.getInputs());
        ScalarFunctionCallExpression recordCreationFunc = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR), closedRecArgs);
        recordCreationFunc.setSourceLocation(unnest.getSourceLocation());
        AssignOperator assignOp = new AssignOperator(unnest.getVariable(), (Mutable)new MutableObject((Object)recordCreationFunc));
        assignOp.getInputs().add(new MutableObject((Object)scan));
        assignOp.setSourceLocation(unnest.getSourceLocation());
        ctx.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)scan);
        ctx.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
        opRef.setValue((Object)assignOp);
    }

    @Override
    protected boolean invalidArgs(List<Mutable<ILogicalExpression>> args) {
        return args.size() < 3;
    }

    private FunctionDataSource createQueryIndexDatasource(MetadataProvider mp, Dataset ds, Index idx, SourceLocation loc, AbstractFunctionCallExpression f) throws AlgebricksException {
        ISecondaryIndexOperationsHelper secIdxHelper = SecondaryIndexOperationsHelper.createIndexOperationsHelper((Dataset)ds, (Index)idx, (MetadataProvider)mp, (SourceLocation)loc);
        AlgebricksAbsolutePartitionConstraint secPartitionConstraint = (AlgebricksAbsolutePartitionConstraint)secIdxHelper.getSecondaryPartitionConstraint();
        INodeDomain domain = mp.findNodeDomain(ds.getNodeGroupName());
        ARecordType recType = this.computeRecType(f, mp, null, null, null);
        int numSecKeys = ((Index.ValueIndexDetails)idx.getIndexDetails()).getKeyFieldNames().size();
        return new QueryIndexDatasource(ds, idx.getIndexName(), domain, secPartitionConstraint, recType, numSecKeys);
    }

    private ARecordType computeRecType(AbstractFunctionCallExpression f, MetadataProvider metadataProvider, List<LogicalVariable> outVars, List<Mutable<ILogicalExpression>> closedRecArgs, IOptimizationContext context) throws AlgebricksException {
        SourceLocation loc = f.getSourceLocation();
        DataverseName dataverseName = this.getDataverseName(loc, f.getArguments(), 0);
        String datasetName = this.getString(loc, f.getArguments(), 1);
        String indexName = this.getString(loc, f.getArguments(), 2);
        String databaseName = f.getArguments().size() > 3 ? this.getString(loc, f.getArguments(), 3) : MetadataUtil.databaseFor((DataverseName)dataverseName);
        Dataset dataset = QueryIndexRewriter.validateDataset(metadataProvider, databaseName, dataverseName, datasetName, loc);
        Index index = QueryIndexRewriter.validateIndex(f, metadataProvider, loc, databaseName, dataverseName, datasetName, indexName);
        ARecordType dsType = (ARecordType)metadataProvider.findType(dataset);
        ARecordType metaType = DatasetUtil.getMetaType((MetadataProvider)metadataProvider, (Dataset)dataset);
        dsType = (ARecordType)metadataProvider.findTypeForDatasetWithoutType((IAType)dsType, (IAType)metaType, dataset);
        List dsKeyTypes = KeyFieldTypeUtil.getPartitoningKeyTypes((Dataset)dataset, (ARecordType)dsType, (ARecordType)metaType);
        List secKeyTypes = KeyFieldTypeUtil.getBTreeIndexKeyTypes((Index)index, (ARecordType)dsType, (ARecordType)metaType);
        int numPrimaryKeys = dsKeyTypes.size();
        int numSecKeys = secKeyTypes.size();
        String[] fieldNames = new String[numSecKeys + numPrimaryKeys];
        IAType[] fieldTypes = new IAType[numSecKeys + numPrimaryKeys];
        int keyIdx = 0;
        boolean overridingKeyFieldTypes = index.getIndexDetails().isOverridingKeyFieldTypes();
        int i = 0;
        while (i < numSecKeys) {
            IAType secKeyType = (IAType)((Pair)secKeyTypes.get((int)i)).first;
            Boolean makeOptional = (Boolean)((Pair)secKeyTypes.get((int)i)).second;
            fieldTypes[keyIdx] = overridingKeyFieldTypes || makeOptional != false ? AUnionType.createUnknownableType((IAType)secKeyType) : secKeyType;
            fieldNames[keyIdx] = "SK" + i;
            this.setAssignVarsExprs(outVars, closedRecArgs, context, loc, fieldNames, keyIdx);
            ++i;
            ++keyIdx;
        }
        int k = 0;
        while (k < numPrimaryKeys) {
            fieldTypes[keyIdx] = (IAType)dsKeyTypes.get(k);
            fieldNames[keyIdx] = "PK" + k;
            this.setAssignVarsExprs(outVars, closedRecArgs, context, loc, fieldNames, keyIdx);
            ++k;
            ++keyIdx;
        }
        return new ARecordType("", fieldNames, fieldTypes, false);
    }

    private void setAssignVarsExprs(List<LogicalVariable> outVars, List<Mutable<ILogicalExpression>> closedRecArgs, IOptimizationContext context, SourceLocation loc, String[] fieldNames, int n) {
        if (context != null) {
            LogicalVariable logicalVariable = context.newVar();
            outVars.add(logicalVariable);
            ConstantExpression nameExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString(fieldNames[n])));
            VariableReferenceExpression varRefExpr = new VariableReferenceExpression(logicalVariable);
            nameExpr.setSourceLocation(loc);
            varRefExpr.setSourceLocation(loc);
            closedRecArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)nameExpr));
            closedRecArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)varRefExpr));
        }
    }

    private static Dataset validateDataset(MetadataProvider mp, String dbName, DataverseName dvName, String dsName, SourceLocation loc) throws AlgebricksException {
        Dataset dataset = mp.findDataset(dbName, dvName, dsName);
        if (dataset == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, loc, new Serializable[]{dsName, MetadataUtil.dataverseName((String)dbName, (DataverseName)dvName, (boolean)mp.isUsingDatabase())});
        }
        return dataset;
    }

    private static Index validateIndex(AbstractFunctionCallExpression f, MetadataProvider mp, SourceLocation loc, String database, DataverseName dvName, String dsName, String idxName) throws AlgebricksException {
        Index index = mp.getIndex(database, dvName, dsName, idxName);
        if (index == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_INDEX, loc, new Serializable[]{idxName});
        }
        if (index.isPrimaryIndex()) {
            throw new CompilationException(ErrorCode.OPERATION_NOT_SUPPORTED_ON_PRIMARY_INDEX, loc, new Serializable[]{idxName});
        }
        DatasetConfig.IndexType idxType = index.getIndexType();
        if (idxType != DatasetConfig.IndexType.BTREE || Index.IndexCategory.of((DatasetConfig.IndexType)idxType) != Index.IndexCategory.VALUE || index.isPrimaryKeyIndex()) {
            throw new CompilationException(ErrorCode.COMPILATION_FUNC_EXPRESSION_CANNOT_UTILIZE_INDEX, f.getSourceLocation(), new Serializable[]{LogRedactionUtil.userData((String)f.toString())});
        }
        return index;
    }
}

