/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class ConsolidateLeftOuterJoinSelectsRule
implements IAlgebraicRewriteRule {
    private final List<Mutable<ILogicalExpression>> conditions = new ArrayList<Mutable<ILogicalExpression>>();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        this.conditions.clear();
        IAlgebricksConstantValue missingValue = null;
        LogicalVariable missingVariable = null;
        ILogicalOperator nextOp = op;
        do {
            SelectOperator selectOp = (SelectOperator)nextOp;
            if (missingValue == null) {
                missingValue = selectOp.getRetainMissingAsValue();
                missingVariable = selectOp.getMissingPlaceholderVariable();
            }
            this.conditions.add((Mutable<ILogicalExpression>)new MutableObject((Object)((ILogicalExpression)selectOp.getCondition().getValue())));
        } while ((nextOp = (ILogicalOperator)((Mutable)nextOp.getInputs().get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.SELECT);
        if (this.conditions.size() < 2 || missingValue == null) {
            return false;
        }
        SelectOperator newSelect = new SelectOperator(this.createAndCondition(context), missingValue, missingVariable);
        newSelect.getInputs().add(new MutableObject((Object)nextOp));
        opRef.setValue((Object)newSelect);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newSelect);
        return true;
    }

    private Mutable<ILogicalExpression> createAndCondition(IOptimizationContext context) {
        IFunctionInfo fInfo = context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.AND);
        return new MutableObject((Object)new ScalarFunctionCallExpression(fInfo, new ArrayList<Mutable<ILogicalExpression>>(this.conditions)));
    }
}

