/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.query;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.column.assembler.value.IValueGetterFactory;
import org.apache.asterix.column.filter.FalseColumnFilterEvaluator;
import org.apache.asterix.column.filter.FilterAccessorProvider;
import org.apache.asterix.column.filter.IColumnFilterEvaluator;
import org.apache.asterix.column.filter.TrueColumnFilterEvaluator;
import org.apache.asterix.column.filter.iterable.ColumnFilterEvaluatorContext;
import org.apache.asterix.column.filter.iterable.IColumnIterableFilterEvaluator;
import org.apache.asterix.column.filter.iterable.IColumnIterableFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.IColumnRangeFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.IColumnRangeFilterValueAccessor;
import org.apache.asterix.column.metadata.AbstractColumnImmutableReadMetadata;
import org.apache.asterix.column.metadata.FieldNamesDictionary;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ObjectSchemaNode;
import org.apache.asterix.column.metadata.schema.visitor.SchemaClipperVisitor;
import org.apache.asterix.column.operation.query.ColumnAssembler;
import org.apache.asterix.column.operation.query.QueryColumnTupleReader;
import org.apache.asterix.column.util.SchemaStringBuilderVisitor;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.IColumnValuesReaderFactory;
import org.apache.asterix.column.values.reader.PrimitiveColumnValuesReader;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.storage.am.lsm.btree.column.api.AbstractColumnTupleReader;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryColumnMetadata
extends AbstractColumnImmutableReadMetadata {
    private static final Logger LOGGER = LogManager.getLogger();
    private final FieldNamesDictionary fieldNamesDictionary;
    private final PrimitiveColumnValuesReader[] primaryKeyReaders;
    private final IColumnFilterEvaluator normalizedFilterEvaluator;
    private final List<IColumnRangeFilterValueAccessor> filterValueAccessors;
    private final IColumnIterableFilterEvaluator columnFilterEvaluator;
    private final List<IColumnValuesReader> filterColumnReaders;
    protected final ColumnAssembler assembler;

    protected QueryColumnMetadata(ARecordType datasetType, ARecordType metaType, PrimitiveColumnValuesReader[] primaryKeyReaders, IValueReference serializedMetadata, FieldNamesDictionary fieldNamesDictionary, ObjectSchemaNode root, IColumnValuesReaderFactory readerFactory, IValueGetterFactory valueGetterFactory, IColumnFilterEvaluator normalizedFilterEvaluator, List<IColumnRangeFilterValueAccessor> filterValueAccessors, IColumnIterableFilterEvaluator columnFilterEvaluator, List<IColumnValuesReader> filterColumnReaders) throws HyracksDataException {
        super(datasetType, metaType, primaryKeyReaders.length, serializedMetadata, -1);
        this.fieldNamesDictionary = fieldNamesDictionary;
        this.primaryKeyReaders = primaryKeyReaders;
        this.normalizedFilterEvaluator = normalizedFilterEvaluator;
        this.filterValueAccessors = filterValueAccessors;
        this.columnFilterEvaluator = columnFilterEvaluator;
        this.filterColumnReaders = filterColumnReaders;
        this.assembler = new ColumnAssembler(root, datasetType, this, readerFactory, valueGetterFactory);
    }

    public final ColumnAssembler getAssembler() {
        return this.assembler;
    }

    public final FieldNamesDictionary getFieldNamesDictionary() {
        return this.fieldNamesDictionary;
    }

    public final PrimitiveColumnValuesReader[] getPrimaryKeyReaders() {
        return this.primaryKeyReaders;
    }

    public final IColumnFilterEvaluator getRangeFilterEvaluator() {
        return this.normalizedFilterEvaluator;
    }

    public final List<IColumnRangeFilterValueAccessor> getFilterValueAccessors() {
        return this.filterValueAccessors;
    }

    public final IColumnIterableFilterEvaluator getColumnFilterEvaluator() {
        return this.columnFilterEvaluator;
    }

    public final List<IColumnValuesReader> getFilterColumnReaders() {
        return this.filterColumnReaders;
    }

    public boolean containsMeta() {
        return false;
    }

    public int getColumnIndex(int ordinal) {
        return this.assembler.getColumnIndex(ordinal);
    }

    public int getFilteredColumnIndex(int ordinal) {
        return this.filterColumnReaders.get(ordinal).getColumnIndex();
    }

    public int getNumberOfProjectedColumns() {
        return this.assembler.getNumberOfColumns();
    }

    public int getNumberOfFilteredColumns() {
        return this.filterColumnReaders.size();
    }

    @Override
    public int getNumberOfColumns() {
        return this.assembler.getNumberOfColumns();
    }

    @Override
    public AbstractColumnTupleReader createTupleReader() {
        return new QueryColumnTupleReader(this);
    }

    public static QueryColumnMetadata create(ARecordType datasetType, int numberOfPrimaryKeys, IValueReference serializedMetadata, IColumnValuesReaderFactory readerFactory, IValueGetterFactory valueGetterFactory, ARecordType requestedType, Map<String, FunctionCallInformation> functionCallInfoMap, IColumnRangeFilterEvaluatorFactory normalizedEvaluatorFactory, IColumnIterableFilterEvaluatorFactory columnFilterEvaluatorFactory, IWarningCollector warningCollector, IHyracksTaskContext context) throws IOException {
        byte[] bytes = serializedMetadata.getByteArray();
        int offset = serializedMetadata.getStartOffset();
        int length = serializedMetadata.getLength();
        int fieldNamesStart = offset + IntegerPointable.getInteger((byte[])bytes, (int)(offset + 4));
        int metaRootStart = IntegerPointable.getInteger((byte[])bytes, (int)(offset + 12));
        int metaRootSize = metaRootStart < 0 ? 0 : IntegerPointable.getInteger((byte[])bytes, (int)(offset + 16)) - metaRootStart;
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes, fieldNamesStart, length));
        FieldNamesDictionary fieldNamesDictionary = FieldNamesDictionary.deserialize(input);
        ObjectSchemaNode root = (ObjectSchemaNode)AbstractSchemaNode.deserialize(input, null);
        input.skipBytes(metaRootSize);
        SchemaClipperVisitor clipperVisitor = new SchemaClipperVisitor(fieldNamesDictionary, functionCallInfoMap, warningCollector);
        ObjectSchemaNode clippedRoot = QueryColumnMetadata.clip(requestedType, root, clipperVisitor);
        IColumnFilterEvaluator normalizedFilterEvaluator = TrueColumnFilterEvaluator.INSTANCE;
        IColumnIterableFilterEvaluator columnFilterEvaluator = TrueColumnFilterEvaluator.INSTANCE;
        List<IColumnValuesReader> filterColumnReaders = Collections.emptyList();
        List<IColumnRangeFilterValueAccessor> filterValueAccessors = Collections.emptyList();
        String jobId = null;
        if (context != null) {
            FilterAccessorProvider accessorProvider = new FilterAccessorProvider(root, clipperVisitor, readerFactory, valueGetterFactory);
            normalizedFilterEvaluator = normalizedEvaluatorFactory.create(accessorProvider);
            filterValueAccessors = accessorProvider.getFilterAccessors();
            ColumnFilterEvaluatorContext evaluatorContext = new ColumnFilterEvaluatorContext(context, accessorProvider);
            clipperVisitor.setIgnoreFlatType(true);
            accessorProvider.reset();
            columnFilterEvaluator = columnFilterEvaluatorFactory.create(evaluatorContext);
            filterColumnReaders = accessorProvider.getFilterColumnReaders();
            jobId = context.getJobletContext().getJobId().toString();
        }
        QueryColumnMetadata.logFilter(jobId, normalizedFilterEvaluator, normalizedEvaluatorFactory.toString());
        QueryColumnMetadata.logSchema(jobId, clippedRoot, SchemaStringBuilderVisitor.RECORD_SCHEMA, fieldNamesDictionary);
        PrimitiveColumnValuesReader[] primaryKeyReaders = QueryColumnMetadata.createPrimaryKeyReaders(input, readerFactory, numberOfPrimaryKeys);
        return new QueryColumnMetadata(datasetType, null, primaryKeyReaders, serializedMetadata, fieldNamesDictionary, clippedRoot, readerFactory, valueGetterFactory, normalizedFilterEvaluator, filterValueAccessors, columnFilterEvaluator, filterColumnReaders);
    }

    protected static ObjectSchemaNode clip(ARecordType requestedType, ObjectSchemaNode root, SchemaClipperVisitor clipperVisitor) {
        ObjectSchemaNode clippedRoot = ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE.getTypeName().equals(requestedType.getTypeName()) ? root : (ObjectSchemaNode)requestedType.accept((IATypeVisitor)clipperVisitor, (Object)root);
        return clippedRoot;
    }

    protected static PrimitiveColumnValuesReader[] createPrimaryKeyReaders(DataInput input, IColumnValuesReaderFactory readerFactory, int numberOfPrimaryKeys) throws IOException {
        input.readInt();
        PrimitiveColumnValuesReader[] primaryKeyReaders = new PrimitiveColumnValuesReader[numberOfPrimaryKeys];
        for (int i = 0; i < numberOfPrimaryKeys; ++i) {
            primaryKeyReaders[i] = (PrimitiveColumnValuesReader)readerFactory.createValueReader(input);
        }
        return primaryKeyReaders;
    }

    protected static void logFilter(String jobId, IColumnFilterEvaluator normalizedFilterEvaluator, String filterExpression) {
        if (jobId != null && LOGGER.isDebugEnabled() && normalizedFilterEvaluator != TrueColumnFilterEvaluator.INSTANCE) {
            String filterString = normalizedFilterEvaluator == FalseColumnFilterEvaluator.INSTANCE ? "SKIP_ALL" : LogRedactionUtil.userData((String)filterExpression);
            LOGGER.debug("Filter [{}]: {}", (Object)jobId, (Object)filterString);
        }
    }

    protected static void logSchema(String jobId, ObjectSchemaNode root, String schemaSource, FieldNamesDictionary fieldNamesDictionary) throws HyracksDataException {
        if (jobId != null && LOGGER.isDebugEnabled()) {
            SchemaStringBuilderVisitor schemaBuilder = new SchemaStringBuilderVisitor(fieldNamesDictionary);
            String schema = LogRedactionUtil.userData((String)schemaBuilder.build(root));
            LOGGER.debug("Queried {} schema [{}]: \n {}", (Object)schemaSource, (Object)jobId, (Object)schema);
        }
    }
}

