/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.validation;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.column.util.ColumnValuesUtil;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ColumnSupportedTypesValidator
implements IATypeVisitor<Void, Set<ATypeTag>> {
    private static final Set<ATypeTag> SUPPORTED_PRIMITIVE_TYPES = Set.of(ATypeTag.BOOLEAN, ATypeTag.BIGINT, ATypeTag.FLOAT, ATypeTag.DOUBLE, ATypeTag.STRING, ATypeTag.UUID);
    private static final String SUPPORTED_TYPES_STRING = SUPPORTED_PRIMITIVE_TYPES.stream().sorted().collect(Collectors.toList()).toString();
    private static final ColumnSupportedTypesValidator VALIDATOR = new ColumnSupportedTypesValidator();

    private ColumnSupportedTypesValidator() {
    }

    public static void validate(DatasetConfig.DatasetFormat format, IAType type) throws CompilationException {
        ColumnSupportedTypesValidator.validate(format, type, null);
    }

    public static void validate(DatasetConfig.DatasetFormat format, IAType type, SourceLocation sourceLocation) throws CompilationException {
        if (format != DatasetConfig.DatasetFormat.COLUMN) {
            return;
        }
        HashSet unsupportedTypes = new HashSet();
        type.accept((IATypeVisitor)VALIDATOR, unsupportedTypes);
        if (!unsupportedTypes.isEmpty()) {
            String unsupportedList = unsupportedTypes.stream().sorted().collect(Collectors.toList()).toString();
            throw CompilationException.create((ErrorCode)ErrorCode.UNSUPPORTED_COLUMN_TYPE, (SourceLocation)sourceLocation, (Serializable[])new Serializable[]{unsupportedList, SUPPORTED_TYPES_STRING});
        }
    }

    public Void visit(ARecordType recordType, Set<ATypeTag> arg) {
        for (IAType fieldType : recordType.getFieldTypes()) {
            fieldType.accept((IATypeVisitor)this, arg);
        }
        return null;
    }

    public Void visit(AbstractCollectionType collectionType, Set<ATypeTag> arg) {
        return (Void)collectionType.getItemType().accept((IATypeVisitor)this, arg);
    }

    public Void visit(AUnionType unionType, Set<ATypeTag> arg) {
        for (IAType fieldType : unionType.getUnionList()) {
            fieldType.accept((IATypeVisitor)this, arg);
        }
        return null;
    }

    public Void visitFlat(IAType flatType, Set<ATypeTag> arg) {
        ATypeTag typeTag = ColumnValuesUtil.getNormalizedTypeTag(flatType.getTypeTag());
        if (typeTag != ATypeTag.ANY && typeTag != ATypeTag.NULL && typeTag != ATypeTag.MISSING && !SUPPORTED_PRIMITIVE_TYPES.contains(typeTag)) {
            arg.add(typeTag);
        }
        return null;
    }
}

