/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.reader;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import org.apache.asterix.column.bytes.decoder.ParquetRunLengthBitPackingHybridDecoder;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.bytes.stream.in.ByteBufferInputStream;
import org.apache.asterix.column.bytes.stream.in.MultiByteBufferInputStream;
import org.apache.asterix.column.util.ColumnValuesUtil;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.IColumnValuesWriter;
import org.apache.asterix.column.values.reader.value.AbstractValueReader;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.bytes.BytesUtils;

abstract class AbstractColumnValuesReader
implements IColumnValuesReader {
    protected final AbstractValueReader valueReader;
    protected final int columnIndex;
    protected final int maxLevel;
    protected final ParquetRunLengthBitPackingHybridDecoder definitionLevels;
    protected final AbstractBytesInputStream valuesStream;
    private final boolean primaryKey;
    protected int level;
    protected int valueCount;
    protected int valueIndex;
    private int nullBitMask;
    private boolean nullLevel;
    private boolean allMissing;
    private int numberOfEncounteredMissing;
    private int numberOfEncounteredNull;

    AbstractColumnValuesReader(AbstractValueReader valueReader, int columnIndex, int maxLevel, boolean primaryKey) {
        this.valueReader = valueReader;
        this.columnIndex = columnIndex;
        this.maxLevel = valueReader.getTypeTag() == ATypeTag.MISSING ? Integer.MAX_VALUE : maxLevel;
        this.definitionLevels = new ParquetRunLengthBitPackingHybridDecoder(ColumnValuesUtil.getBitWidth(maxLevel));
        this.valuesStream = primaryKey ? new ByteBufferInputStream() : new MultiByteBufferInputStream();
        this.primaryKey = primaryKey;
    }

    final void nextLevel() throws HyracksDataException {
        ++this.valueIndex;
        if (this.allMissing) {
            return;
        }
        int actualLevel = this.definitionLevels.readInt();
        this.nullLevel = ColumnValuesUtil.isNull(this.nullBitMask, actualLevel);
        this.level = ColumnValuesUtil.clearNullBit(this.nullBitMask, actualLevel);
        this.numberOfEncounteredMissing += this.isMissing() ? 1 : 0;
        this.numberOfEncounteredNull += this.isNull() ? 1 : 0;
    }

    abstract void resetValues();

    @Override
    public final void reset(AbstractBytesInputStream in, int tupleCount) throws HyracksDataException {
        this.valueIndex = 0;
        this.numberOfEncounteredMissing = 0;
        this.numberOfEncounteredNull = 0;
        if (in.available() == 0) {
            this.allMissing = true;
            this.level = 0;
            this.valueCount = tupleCount;
            return;
        }
        this.allMissing = false;
        try {
            this.nullBitMask = ColumnValuesUtil.getNullMask(BytesUtils.readZigZagVarInt((InputStream)in));
            int defLevelsSize = BytesUtils.readZigZagVarInt((InputStream)in);
            this.valueCount = BytesUtils.readZigZagVarInt((InputStream)in);
            this.definitionLevels.reset(in);
            this.valuesStream.resetAt(defLevelsSize, in);
            int valueLength = BytesUtils.readZigZagVarInt((InputStream)this.valuesStream);
            if (valueLength > 0) {
                this.valueReader.init(this.valuesStream, tupleCount);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        this.resetValues();
    }

    @Override
    public final ATypeTag getTypeTag() {
        return this.valueReader.getTypeTag();
    }

    @Override
    public final int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public final boolean isMissing() {
        return !this.isDelimiter() && this.level < this.maxLevel;
    }

    @Override
    public final boolean isNull() {
        return this.nullLevel;
    }

    @Override
    public final boolean isValue() {
        return !this.isNull() && this.level == this.maxLevel;
    }

    @Override
    public final long getLong() {
        return this.valueReader.getLong();
    }

    @Override
    public float getFloat() {
        return this.valueReader.getFloat();
    }

    @Override
    public final double getDouble() {
        return this.valueReader.getDouble();
    }

    @Override
    public final boolean getBoolean() {
        return this.valueReader.getBoolean();
    }

    @Override
    public final IValueReference getBytes() {
        return this.valueReader.getBytes();
    }

    @Override
    public final int compareTo(IColumnValuesReader o) {
        return this.valueReader.compareTo(((AbstractColumnValuesReader)o).valueReader);
    }

    @Override
    public final void write(IColumnValuesWriter writer, int count) throws HyracksDataException {
        for (int i = 0; i < count; ++i) {
            this.write(writer, true);
        }
    }

    @Override
    public void skip(int count) throws HyracksDataException {
        if (this.primaryKey) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            this.next();
        }
    }

    protected void appendCommon(ObjectNode node) {
        node.put("typeTag", this.getTypeTag().toString());
        node.put("columnIndex", this.columnIndex);
        node.put("valueIndex", this.valueIndex);
        node.put("valueCount", this.valueCount);
        node.put("allMissing", this.allMissing);
        node.put("level", this.level);
        node.put("maxLevel", this.maxLevel);
        node.put("nullBitMask", this.nullBitMask);
        node.put("numberOfEncounteredMissing", this.numberOfEncounteredMissing);
        node.put("numberOfEncounteredNull", this.numberOfEncounteredNull);
    }
}

