/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.dataflow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.compression.ICompressorDecompressorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnManagerFactory;
import org.apache.hyracks.storage.am.lsm.btree.column.utils.LSMColumnBTreeUtil;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.LSMBTreeLocalResource;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.compression.NoOpCompressorDecompressorFactory;

public class LSMColumnBTreeLocalResource
extends LSMBTreeLocalResource {
    private final IColumnManagerFactory columnManagerFactory;

    public LSMColumnBTreeLocalResource(ITypeTraits[] typeTraits, IBinaryComparatorFactory[] cmpFactories, int[] bloomFilterKeyFields, double bloomFilterFalsePositiveRate, String path, IStorageManager storageManager, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, int[] btreeFields, ILSMOperationTrackerFactory opTrackerProvider, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, IMetadataPageManagerFactory metadataPageManagerFactory, IVirtualBufferCacheProvider vbcProvider, ILSMIOOperationSchedulerProvider ioSchedulerProvider, ICompressorDecompressorFactory compressorDecompressorFactory, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector, boolean isSecondaryNoIncrementalMaintenance, IColumnManagerFactory columnManagerFactory, boolean atomic) {
        super(typeTraits, cmpFactories, bloomFilterKeyFields, bloomFilterFalsePositiveRate, true, path, storageManager, mergePolicyFactory, mergePolicyProperties, null, null, btreeFields, null, opTrackerProvider, ioOpCallbackFactory, pageWriteCallbackFactory, metadataPageManagerFactory, vbcProvider, ioSchedulerProvider, true, compressorDecompressorFactory, true, nullTypeTraits, nullIntrospector, isSecondaryNoIncrementalMaintenance, atomic);
        this.columnManagerFactory = columnManagerFactory;
    }

    private LSMColumnBTreeLocalResource(IPersistedResourceRegistry registry, JsonNode json, int[] bloomFilterKeyFields, double bloomFilterFalsePositiveRate, boolean isPrimary, int[] btreeFields, ICompressorDecompressorFactory compressorDecompressorFactory, boolean hasBloomFilter, boolean isSecondaryNoIncrementalMaintenance, IColumnManagerFactory columnManagerFactory, boolean atomic) throws HyracksDataException {
        super(registry, json, bloomFilterKeyFields, bloomFilterFalsePositiveRate, isPrimary, btreeFields, compressorDecompressorFactory, hasBloomFilter, isSecondaryNoIncrementalMaintenance, atomic);
        this.columnManagerFactory = columnManagerFactory;
    }

    public ILSMIndex createInstance(INCServiceContext serviceCtx) throws HyracksDataException {
        IIOManager ioManager = this.storageManager.getIoManager(serviceCtx);
        FileReference file = ioManager.resolve(this.path);
        List vbcs = this.vbcProvider.getVirtualBufferCaches(serviceCtx, file);
        this.ioOpCallbackFactory.initialize(serviceCtx, (IResource)this);
        this.pageWriteCallbackFactory.initialize(serviceCtx, (IResource)this);
        return LSMColumnBTreeUtil.createLSMTree(ioManager, vbcs, file, this.storageManager.getBufferCache(serviceCtx), this.typeTraits, this.cmpFactories, this.bloomFilterKeyFields, this.bloomFilterFalsePositiveRate, this.mergePolicyFactory.createMergePolicy(this.mergePolicyProperties, serviceCtx), this.opTrackerProvider.getOperationTracker(serviceCtx, (IResource)this), this.ioSchedulerProvider.getIoScheduler(serviceCtx), this.ioOpCallbackFactory, this.pageWriteCallbackFactory, this.btreeFields, this.metadataPageManagerFactory, false, serviceCtx.getTracer(), this.compressorDecompressorFactory, this.nullTypeTraits, this.nullIntrospector, this.columnManagerFactory, this.atomic);
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        int[] bloomFilterKeyFields = (int[])OBJECT_MAPPER.convertValue((Object)json.get("bloomFilterKeyFields"), int[].class);
        double bloomFilterFalsePositiveRate = json.get("bloomFilterFalsePositiveRate").asDouble();
        boolean isPrimary = json.get("isPrimary").asBoolean();
        boolean hasBloomFilter = LSMColumnBTreeLocalResource.getOrDefaultHasBloomFilter((JsonNode)json, (boolean)isPrimary);
        int[] btreeFields = (int[])OBJECT_MAPPER.convertValue((Object)json.get("btreeFields"), int[].class);
        JsonNode compressorDecompressorNode = json.get("compressorDecompressorFactory");
        ICompressorDecompressorFactory compDecompFactory = (ICompressorDecompressorFactory)registry.deserializeOrDefault(compressorDecompressorNode, NoOpCompressorDecompressorFactory.class);
        JsonNode columnManagerFactoryNode = json.get("columnManagerFactory");
        boolean isSecondaryNoIncrementalMaintenance = LSMColumnBTreeLocalResource.getOrDefaultBoolean((JsonNode)json, (String)"isSecondaryNoIncrementalMaintenance", (boolean)false);
        boolean atomic = LSMColumnBTreeLocalResource.getOrDefaultBoolean((JsonNode)json, (String)"atomic", (boolean)false);
        IColumnManagerFactory columnManagerFactory = (IColumnManagerFactory)registry.deserialize(columnManagerFactoryNode);
        return new LSMColumnBTreeLocalResource(registry, json, bloomFilterKeyFields, bloomFilterFalsePositiveRate, isPrimary, btreeFields, compDecompFactory, hasBloomFilter, isSecondaryNoIncrementalMaintenance, columnManagerFactory, atomic);
    }

    protected void appendToJson(ObjectNode json, IPersistedResourceRegistry registry) throws HyracksDataException {
        super.appendToJson(json, registry);
        json.putPOJO("columnManagerFactory", (Object)this.columnManagerFactory.toJson(registry));
    }
}

