/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm;

import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnManager;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnMetadata;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnTupleProjector;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.LSMColumnBTreeOpContext;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.LSMColumnBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.LSMColumnBTreeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.LSMColumnBTreeWithBloomFilterDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.LSMColumnBatchPointSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.column.utils.ColumnUtil;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeBatchPointSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.DiskComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.util.trace.ITracer;

public class LSMColumnBTree
extends LSMBTree {
    private static final LSMTreeIndexAccessor.ICursorFactory CURSOR_FACTORY = LSMColumnBTreeSearchCursor::new;
    private final IColumnManager columnManager;
    private final ILSMDiskComponentFactory mergeComponentFactory;
    private IColumnMetadata columnMetadata;

    public LSMColumnBTree(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, ILSMDiskComponentFactory componentFactory, ILSMDiskComponentFactory mergeComponentFactory, ILSMDiskComponentFactory bulkloadComponentFactory, double bloomFilterFalsePositiveRate, int fieldCount, IBinaryComparatorFactory[] cmpFactories, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, int[] btreeFields, ITracer tracer, IColumnManager columnManager, boolean atomic) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, interiorFrameFactory, insertLeafFrameFactory, deleteLeafFrameFactory, diskBufferCache, fileManager, componentFactory, bulkloadComponentFactory, null, null, null, bloomFilterFalsePositiveRate, fieldCount, cmpFactories, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, pageWriteCallbackFactory, true, true, btreeFields, null, true, false, tracer, atomic);
        this.columnManager = columnManager;
        this.mergeComponentFactory = mergeComponentFactory;
    }

    public synchronized void activate() throws HyracksDataException {
        super.activate();
        if (this.diskComponents.isEmpty()) {
            this.columnMetadata = this.columnManager.activate();
        } else {
            DiskComponentMetadata componentMetadata = ((ILSMDiskComponent)this.diskComponents.get(0)).getMetadata();
            this.columnMetadata = this.columnManager.activate(ColumnUtil.getColumnMetadataCopy((IComponentMetadata)componentMetadata));
        }
    }

    public LSMColumnBTreeOpContext createOpContext(IIndexAccessParameters iap) {
        int numBloomFilterKeyFields = ((LSMColumnBTreeWithBloomFilterDiskComponentFactory)this.componentFactory).getBloomFilterKeyFields().length;
        IColumnTupleProjector tupleProjector = ColumnUtil.getTupleProjector(iap, this.columnManager.getMergeColumnProjector());
        return new LSMColumnBTreeOpContext((ILSMIndex)this, this.memoryComponents, this.insertLeafFrameFactory, this.deleteLeafFrameFactory, (IExtendedModificationOperationCallback)iap.getModificationCallback(), iap.getSearchOperationCallback(), numBloomFilterKeyFields, this.getTreeFields(), this.getFilterFields(), this.getHarness(), this.getFilterCmpFactories(), this.tracer, tupleProjector);
    }

    protected IColumnManager getColumnManager() {
        return this.columnManager;
    }

    protected IColumnMetadata getColumnMetadata() {
        return this.columnMetadata;
    }

    protected LSMBTreeRangeSearchCursor createCursor(AbstractLSMIndexOperationContext opCtx, boolean returnDeletedTuples, IIndexCursorStats stats) {
        return new LSMColumnBTreeRangeSearchCursor((ILSMIndexOperationContext)opCtx, returnDeletedTuples, stats);
    }

    public LSMBTreeBatchPointSearchCursor createBatchPointSearchCursor(ILSMIndexOperationContext opCtx) {
        return new LSMColumnBatchPointSearchCursor(opCtx);
    }

    protected ILSMDiskComponentFactory getMergeComponentFactory() {
        return this.mergeComponentFactory;
    }

    public LSMTreeIndexAccessor.ICursorFactory getCursorFactory() {
        return CURSOR_FACTORY;
    }
}

