/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnTupleIterator;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTree;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.LSMColumnBTreeOpContext;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.tuples.ColumnAwareDiskOnlyMultiComparator;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.NoOpIndexCursorStats;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LSMColumnBTreeRangeSearchCursor
extends LSMBTreeRangeSearchCursor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<IColumnTupleIterator> componentTupleList = new ArrayList<IColumnTupleIterator>();

    public LSMColumnBTreeRangeSearchCursor(ILSMIndexOperationContext opCtx) {
        this(opCtx, false, NoOpIndexCursorStats.INSTANCE);
    }

    public LSMColumnBTreeRangeSearchCursor(ILSMIndexOperationContext opCtx, boolean returnDeletedTuples, IIndexCursorStats stats) {
        super(opCtx, returnDeletedTuples, stats);
    }

    protected BTree.BTreeAccessor createAccessor(ILSMComponent.LSMComponentType type, BTree btree, int index) throws HyracksDataException {
        if (type == ILSMComponent.LSMComponentType.MEMORY) {
            return super.createAccessor(type, btree, index);
        }
        ColumnBTree columnBTree = (ColumnBTree)btree;
        LSMColumnBTreeOpContext columnOpCtx = (LSMColumnBTreeOpContext)this.opCtx;
        return columnBTree.createAccessor(this.iap, index, columnOpCtx.createProjectionInfo());
    }

    protected IIndexCursor createCursor(ILSMComponent.LSMComponentType type, BTree.BTreeAccessor accessor) {
        if (type == ILSMComponent.LSMComponentType.MEMORY) {
            return super.createCursor(type, accessor);
        }
        ColumnBTreeRangeSearchCursor cursor = (ColumnBTreeRangeSearchCursor)accessor.createSearchCursor(false);
        this.componentTupleList.add((IColumnTupleIterator)cursor.doGetTuple());
        return cursor;
    }

    protected void markAsDeleted(LSMIndexSearchCursor.PriorityQueueElement e) throws HyracksDataException {
        if (this.isMemoryComponent[e.getCursorIndex()]) {
            super.markAsDeleted(e);
            return;
        }
        IColumnTupleIterator columnTuple = (IColumnTupleIterator)e.getTuple();
        if (!columnTuple.isAntimatter()) {
            columnTuple.skip(1);
        }
    }

    protected void setPriorityQueueComparator() {
        if (!this.includeMutableComponent) {
            this.cmp = new ColumnAwareDiskOnlyMultiComparator(this.cmp);
        }
        if (this.pqCmp == null || this.cmp != this.pqCmp.getMultiComparator()) {
            this.pqCmp = new LSMIndexSearchCursor.PriorityQueueComparator(this.cmp);
        }
    }

    protected void excludeMemoryComponent() {
        this.pqCmp.setMultiComparator((MultiComparator)new ColumnAwareDiskOnlyMultiComparator(this.cmp));
    }

    protected int replaceFrom() {
        return -1;
    }

    public List<IColumnTupleIterator> getComponentTupleList() {
        return this.componentTupleList;
    }
}

