/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.asterix.common.utils.PartitioningScheme;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.util.StorageUtil;

public class StorageProperties
extends AbstractProperties {
    public static final long MAX_HEAP_BYTES = Runtime.getRuntime().maxMemory();
    private static final int SYSTEM_RESERVED_DATASETS = 0;

    public StorageProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public int getBufferCachePageSize() {
        return this.accessor.getInt(Option.STORAGE_BUFFERCACHE_PAGESIZE);
    }

    public long getBufferCacheSize() {
        return this.accessor.getLong(Option.STORAGE_BUFFERCACHE_SIZE);
    }

    public int getBufferCacheMaxOpenFiles() {
        return this.accessor.getInt(Option.STORAGE_BUFFERCACHE_MAXOPENFILES);
    }

    public int getMemoryComponentPageSize() {
        return this.accessor.getInt(Option.STORAGE_MEMORYCOMPONENT_PAGESIZE);
    }

    public double getMemoryComponentFlushThreshold() {
        return this.accessor.getDouble(Option.STORAGE_MEMORYCOMPONENT_FLUSH_THRESHOLD);
    }

    public int getFilteredMemoryComponentMaxNumPages() {
        return (int)(this.accessor.getLong(Option.STORAGE_FILTERED_MEMORYCOMPONENT_MAX_SIZE) / (long)this.getMemoryComponentPageSize());
    }

    public int getMemoryComponentsNum() {
        return this.accessor.getInt(Option.STORAGE_MEMORYCOMPONENT_NUMCOMPONENTS);
    }

    public long getMemoryComponentGlobalBudget() {
        return this.accessor.getLong(Option.STORAGE_MEMORYCOMPONENT_GLOBALBUDGET);
    }

    public double getBloomFilterFalsePositiveRate() {
        return this.accessor.getDouble(Option.STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE);
    }

    public int getBufferCacheNumPages() {
        return (int)(this.getBufferCacheSize() / (long)(this.getBufferCachePageSize() + 8));
    }

    public int getMaxScheduledFlushes() {
        return this.accessor.getInt(Option.STORAGE_MEMORYCOMPONENT_MAX_SCHEDULED_FLUSHES);
    }

    public long getJobExecutionMemoryBudget() {
        long jobExecutionMemory = MAX_HEAP_BYTES - this.getBufferCacheSize() - this.getMemoryComponentGlobalBudget();
        if (jobExecutionMemory <= 0L) {
            String msg = String.format("Invalid node memory configuration, more memory budgeted than available in JVM. Runtime max memory: (%d), Buffer cache memory (%d), memory component global budget (%d)", MAX_HEAP_BYTES, this.getBufferCacheSize(), this.getMemoryComponentGlobalBudget());
            throw new IllegalStateException(msg);
        }
        return jobExecutionMemory;
    }

    public String getCompressionScheme() {
        return this.accessor.getString(Option.STORAGE_COMPRESSION_BLOCK);
    }

    public String getIoScheduler() {
        return this.accessor.getString(Option.STORAGE_IO_SCHEDULER);
    }

    public int geMaxConcurrentFlushes(int numPartitions) {
        int value = this.accessor.getInt(Option.STORAGE_MAX_CONCURRENT_FLUSHES_PER_PARTITION);
        return value != 0 ? value * numPartitions : Integer.MAX_VALUE;
    }

    public int getMaxScheduledMerges(int numPartitions) {
        int value = this.accessor.getInt(Option.STORAGE_MAX_SCHEDULED_MERGES_PER_PARTITION);
        return value != 0 ? value * numPartitions : Integer.MAX_VALUE;
    }

    public int getMaxConcurrentMerges(int numPartitions) {
        int value = this.accessor.getInt(Option.STORAGE_MAX_CONCURRENT_MERGES_PER_PARTITION);
        return value != 0 ? value * numPartitions : Integer.MAX_VALUE;
    }

    public boolean isStorageGlobalCleanup() {
        return this.accessor.getBoolean(Option.STORAGE_GLOBAL_CLEANUP);
    }

    public int getStorageGlobalCleanupTimeout() {
        return this.accessor.getInt(Option.STORAGE_GLOBAL_CLEANUP_TIMEOUT);
    }

    protected int getMetadataDatasets() {
        return 18;
    }

    protected int geSystemReservedDatasets() {
        return 0;
    }

    public long getWriteRateLimit() {
        return this.accessor.getLong(Option.STORAGE_WRITE_RATE_LIMIT);
    }

    public int getDiskForcePages() {
        return (int)(this.accessor.getLong(Option.STORAGE_DISK_FORCE_BYTES) / (long)this.getBufferCachePageSize());
    }

    public int getColumnMaxTupleCount() {
        return this.accessor.getInt(Option.STORAGE_COLUMN_MAX_TUPLE_COUNT);
    }

    public double getColumnFreeSpaceTolerance() {
        return this.accessor.getDouble(Option.STORAGE_COLUMN_FREE_SPACE_TOLERANCE);
    }

    public int getColumnMaxLeafNodeSize() {
        return this.accessor.getInt(Option.STORAGE_COLUMN_MAX_LEAF_NODE_SIZE);
    }

    public String getStorageFormat() {
        return this.accessor.getString(Option.STORAGE_FORMAT);
    }

    public PartitioningScheme getPartitioningScheme() {
        return PartitioningScheme.fromName(this.accessor.getString(Option.STORAGE_PARTITIONING));
    }

    public int getStoragePartitionsCount() {
        return this.accessor.getInt(Option.STORAGE_PARTITIONS_COUNT);
    }

    public static enum Option implements IOption
    {
        STORAGE_BUFFERCACHE_PAGESIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)128, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE)),
        STORAGE_BUFFERCACHE_SIZE(OptionTypes.LONG_BYTE_UNIT, MAX_HEAP_BYTES / 4L),
        STORAGE_BUFFERCACHE_MAXOPENFILES(OptionTypes.NONNEGATIVE_INTEGER, Integer.MAX_VALUE),
        STORAGE_MEMORYCOMPONENT_GLOBALBUDGET(OptionTypes.LONG_BYTE_UNIT, MAX_HEAP_BYTES / 4L),
        STORAGE_MEMORYCOMPONENT_PAGESIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)128, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE)),
        STORAGE_MEMORYCOMPONENT_NUMCOMPONENTS(OptionTypes.POSITIVE_INTEGER, 2),
        STORAGE_MEMORYCOMPONENT_FLUSH_THRESHOLD(OptionTypes.DOUBLE, 0.9),
        STORAGE_MEMORYCOMPONENT_MAX_SCHEDULED_FLUSHES(OptionTypes.NONNEGATIVE_INTEGER, 0),
        STORAGE_FILTERED_MEMORYCOMPONENT_MAX_SIZE(OptionTypes.LONG_BYTE_UNIT, 0L),
        STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE(OptionTypes.DOUBLE, 0.01),
        STORAGE_COMPRESSION_BLOCK(OptionTypes.STRING, "snappy"),
        STORAGE_DISK_FORCE_BYTES(OptionTypes.LONG_BYTE_UNIT, StorageUtil.getLongSizeInBytes((long)16L, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE)),
        STORAGE_IO_SCHEDULER(OptionTypes.STRING, "greedy"),
        STORAGE_WRITE_RATE_LIMIT(OptionTypes.LONG_BYTE_UNIT, 0L),
        STORAGE_MAX_CONCURRENT_FLUSHES_PER_PARTITION(OptionTypes.NONNEGATIVE_INTEGER, 2),
        STORAGE_MAX_SCHEDULED_MERGES_PER_PARTITION(OptionTypes.NONNEGATIVE_INTEGER, 8),
        STORAGE_MAX_CONCURRENT_MERGES_PER_PARTITION(OptionTypes.NONNEGATIVE_INTEGER, 2),
        STORAGE_GLOBAL_CLEANUP(OptionTypes.BOOLEAN, true),
        STORAGE_GLOBAL_CLEANUP_TIMEOUT(OptionTypes.POSITIVE_INTEGER, (int)TimeUnit.MINUTES.toSeconds(10L)),
        STORAGE_COLUMN_MAX_TUPLE_COUNT(OptionTypes.NONNEGATIVE_INTEGER, 15000),
        STORAGE_COLUMN_FREE_SPACE_TOLERANCE(OptionTypes.DOUBLE, 0.15),
        STORAGE_COLUMN_MAX_LEAF_NODE_SIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)10, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.MEGABYTE)),
        STORAGE_FORMAT(OptionTypes.STRING, "row"),
        STORAGE_PARTITIONING(OptionTypes.STRING, "dynamic"),
        STORAGE_PARTITIONS_COUNT(OptionTypes.INTEGER, 8);

        private final IOptionType interpreter;
        private final Object defaultValue;

        private <T> Option(IOptionType<T> interpreter, T defaultValue) {
            this.interpreter = interpreter;
            this.defaultValue = defaultValue;
        }

        public Section section() {
            switch (this) {
                case STORAGE_BUFFERCACHE_PAGESIZE: 
                case STORAGE_COMPRESSION_BLOCK: 
                case STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE: 
                case STORAGE_GLOBAL_CLEANUP: 
                case STORAGE_GLOBAL_CLEANUP_TIMEOUT: 
                case STORAGE_PARTITIONING: 
                case STORAGE_PARTITIONS_COUNT: 
                case STORAGE_FORMAT: 
                case STORAGE_COLUMN_MAX_TUPLE_COUNT: 
                case STORAGE_COLUMN_FREE_SPACE_TOLERANCE: 
                case STORAGE_COLUMN_MAX_LEAF_NODE_SIZE: {
                    return Section.COMMON;
                }
            }
            return Section.NC;
        }

        public String description() {
            switch (this) {
                case STORAGE_BUFFERCACHE_PAGESIZE: {
                    return "The page size in bytes for pages in the buffer cache";
                }
                case STORAGE_BUFFERCACHE_SIZE: {
                    return "The size of memory allocated to the disk buffer cache.  The value should be a multiple of the buffer cache page size.";
                }
                case STORAGE_BUFFERCACHE_MAXOPENFILES: {
                    return "The maximum number of open files in the buffer cache";
                }
                case STORAGE_MEMORYCOMPONENT_GLOBALBUDGET: {
                    return "The size of memory allocated to the memory components.  The value should be a multiple of the memory component page size";
                }
                case STORAGE_MEMORYCOMPONENT_PAGESIZE: {
                    return "The page size in bytes for pages allocated to memory components";
                }
                case STORAGE_MEMORYCOMPONENT_NUMCOMPONENTS: {
                    return "The number of memory components to be used per lsm index";
                }
                case STORAGE_MEMORYCOMPONENT_MAX_SCHEDULED_FLUSHES: {
                    return "The maximum number of scheduled flush operations. 0 means that the value will be calculated as the number of partitions";
                }
                case STORAGE_MEMORYCOMPONENT_FLUSH_THRESHOLD: {
                    return "The memory usage threshold when memory components should be flushed";
                }
                case STORAGE_FILTERED_MEMORYCOMPONENT_MAX_SIZE: {
                    return "The maximum size of a filtered memory component. 0 means that the memory component does not have a maximum size";
                }
                case STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE: {
                    return "The maximum acceptable false positive rate for bloom filters associated with LSM indexes";
                }
                case STORAGE_COMPRESSION_BLOCK: {
                    return "The default compression scheme for the storage";
                }
                case STORAGE_WRITE_RATE_LIMIT: {
                    return "The maximum disk write rate (bytes/s) for each storage partition (disabled if the provided value <= 0)";
                }
                case STORAGE_DISK_FORCE_BYTES: {
                    return "The number of bytes before each disk force (fsync)";
                }
                case STORAGE_IO_SCHEDULER: {
                    return "The I/O scheduler for LSM flush and merge operations";
                }
                case STORAGE_MAX_CONCURRENT_FLUSHES_PER_PARTITION: {
                    return "The maximum number of concurrently executed flushes per partition (0 means unlimited)";
                }
                case STORAGE_MAX_SCHEDULED_MERGES_PER_PARTITION: {
                    return "The maximum number of scheduled merges per partition (0 means unlimited)";
                }
                case STORAGE_MAX_CONCURRENT_MERGES_PER_PARTITION: {
                    return "The maximum number of concurrently executed merges per partition (0 means unlimited)";
                }
                case STORAGE_GLOBAL_CLEANUP: {
                    return "Indicates whether or not global storage cleanup is performed";
                }
                case STORAGE_GLOBAL_CLEANUP_TIMEOUT: {
                    return "The maximum time to wait for nodes to respond to global storage cleanup requests";
                }
                case STORAGE_COLUMN_MAX_TUPLE_COUNT: {
                    return "The maximum number of tuples to be stored per a mega leaf page";
                }
                case STORAGE_COLUMN_FREE_SPACE_TOLERANCE: {
                    return "The percentage of the maximum tolerable empty space for a physical mega leaf page (e.g., 0.15 means a physical page with 15% or less empty space is tolerable)";
                }
                case STORAGE_COLUMN_MAX_LEAF_NODE_SIZE: {
                    return "The maximum mega leaf node to write during flush and merge operations (default: 10MB)";
                }
                case STORAGE_FORMAT: {
                    return "The default storage format (either row or column)";
                }
                case STORAGE_PARTITIONING: {
                    return "The storage partitioning scheme (either dynamic or static). This value should not be changed after any dataset has been created";
                }
                case STORAGE_PARTITIONS_COUNT: {
                    return "The number of storage partitions to use for static partitioning. This value should not be changed after any dataset has been created";
                }
            }
            throw new IllegalStateException("NYI: " + this);
        }

        public IOptionType type() {
            return this.interpreter;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public String usageDefaultOverride(IApplicationConfig accessor, Function<IOption, String> optionPrinter) {
            return null;
        }

        public boolean hidden() {
            return this == STORAGE_GLOBAL_CLEANUP;
        }
    }
}

