/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.Objects;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class Dataverse
implements IMetadataEntity<Dataverse> {
    private static final long serialVersionUID = 3L;
    private final String databaseName;
    private final DataverseName dataverseName;
    private final String dataFormat;
    private final int pendingOp;

    public Dataverse(String databaseName, DataverseName dataverseName, String format, int pendingOp) {
        this.databaseName = Objects.requireNonNull(databaseName);
        this.dataverseName = dataverseName;
        this.dataFormat = format;
        this.pendingOp = pendingOp;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public int getPendingOp() {
        return this.pendingOp;
    }

    @Override
    public Dataverse addToCache(MetadataCache cache) {
        return cache.addDataverseIfNotExists(this);
    }

    @Override
    public Dataverse dropFromCache(MetadataCache cache) {
        return cache.dropDataverse(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.databaseName + ":" + this.dataverseName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Dataverse)) {
            return false;
        }
        Dataverse other = (Dataverse)o;
        return Objects.equals(this.databaseName, other.databaseName) && this.dataverseName.equals((Object)other.getDataverseName());
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.dataverseName);
    }
}

