/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.util.Calendar;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.metadata.bootstrap.LibraryEntity;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class LibraryTupleTranslator
extends AbstractTupleTranslator<Library> {
    private final LibraryEntity libraryEntity;

    protected LibraryTupleTranslator(boolean getTuple, LibraryEntity libraryEntity) {
        super(getTuple, libraryEntity.getIndex(), libraryEntity.payloadPosition());
        this.libraryEntity = libraryEntity;
    }

    @Override
    protected Library createMetadataEntityFromARecord(ARecord libraryRecord) throws AlgebricksException {
        String dataverseCanonicalName = ((AString)libraryRecord.getValueByPos(this.libraryEntity.dataverseNameIndex())).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        int databaseNameIndex = this.libraryEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)libraryRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverseName);
        String libraryName = ((AString)libraryRecord.getValueByPos(this.libraryEntity.libraryNameIndex())).getStringValue();
        ARecordType libraryRecordType = libraryRecord.getType();
        int pendingOpIdx = libraryRecordType.getFieldIndex("PendingOp");
        int pendingOp = pendingOpIdx >= 0 ? ((AInt32)libraryRecord.getValueByPos(pendingOpIdx)).getIntegerValue() : 0;
        int languageIdx = libraryRecordType.getFieldIndex("Language");
        String language = languageIdx >= 0 ? ((AString)libraryRecord.getValueByPos(languageIdx)).getStringValue() : ExternalFunctionLanguage.JAVA.name();
        int hashIdx = libraryRecordType.getFieldIndex("MD5Hash");
        String hash = hashIdx >= 0 ? ((AString)libraryRecord.getValueByPos(hashIdx)).getStringValue() : null;
        return new Library(databaseName, dataverseName, libraryName, language, hash, pendingOp);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Library library) throws HyracksDataException {
        String dataverseCanonicalName = library.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        if (this.libraryEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(library.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
            this.tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(library.getName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.libraryEntity.getRecordType());
        if (this.libraryEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(library.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.libraryEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.libraryEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(library.getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.libraryEntity.libraryNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.libraryEntity.timestampIndex(), (IValueReference)this.fieldValue);
        this.writeOpenFields(library);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    protected void writeOpenFields(Library library) throws HyracksDataException {
        this.writeLanguage(library);
        this.writePendingOp(library);
        this.writeHash(library);
    }

    private void writeLanguage(Library library) throws HyracksDataException {
        String language = library.getLanguage();
        this.fieldName.reset();
        this.aString.setValue("Language");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(language);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    private void writeHash(Library library) throws HyracksDataException {
        String hash = library.getHash();
        this.fieldName.reset();
        this.aString.setValue("MD5Hash");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(hash);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    private void writePendingOp(Library library) throws HyracksDataException {
        int pendingOp = library.getPendingOp();
        if (pendingOp != 0) {
            this.fieldName.reset();
            this.aString.setValue("PendingOp");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.int32Serde.serialize((Object)new AInt32(pendingOp), this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }
}

