/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.buffercache.IRateLimiter;
import org.apache.hyracks.storage.common.buffercache.NoOpRateLimiter;

public class SleepRateLimiter
implements IRateLimiter {
    private static final double MAX_BURST_SECONDS = 1.0;
    private final RateLimiter rateLimiterImpl;

    public static IRateLimiter create(long ratePerSecond) {
        if (ratePerSecond > 0L) {
            return new SleepRateLimiter(ratePerSecond, 1.0);
        }
        return NoOpRateLimiter.INSTANCE;
    }

    public SleepRateLimiter(long ratePerSecond, double maxBurstSeconds) {
        this.rateLimiterImpl = RateLimiter.create((double)ratePerSecond, (long)((long)(maxBurstSeconds * 1000.0)), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public void setRate(double ratePerSecond) {
        this.rateLimiterImpl.setRate(ratePerSecond);
    }

    @Override
    public void request(int permits) throws HyracksDataException {
        this.rateLimiterImpl.acquire(permits);
    }
}

