/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.Collections;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.CopyToStatement;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppAstVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;

public class SqlppCopyToRewriteVisitor
extends AbstractSqlppAstVisitor<Void, MetadataProvider> {
    public static final SqlppCopyToRewriteVisitor INSTANCE = new SqlppCopyToRewriteVisitor();

    public Void visit(CopyToStatement stmtCopy, MetadataProvider metadataProvider) throws CompilationException {
        if (stmtCopy.getNamespace() == null) {
            stmtCopy.setNamespace(metadataProvider.getDefaultNamespace());
        }
        if (stmtCopy.getQuery() == null) {
            this.setQuery(stmtCopy);
        }
        return null;
    }

    private void setQuery(CopyToStatement stmtCopy) {
        DataverseName dataverseName = stmtCopy.getNamespace().getDataverseName();
        String datasetName = stmtCopy.getDatasetName();
        CallExpr callExpression = FunctionUtil.makeDatasetCallExpr((String)stmtCopy.getNamespace().getDatabaseName(), (DataverseName)dataverseName, (String)datasetName);
        callExpression.setSourceLocation(stmtCopy.getSourceLocation());
        VariableExpr var = stmtCopy.getSourceVariable();
        FromTerm fromTerm = new FromTerm((Expression)callExpression, var, null, null);
        fromTerm.setSourceLocation(var.getSourceLocation());
        FromClause fromClause = new FromClause(Collections.singletonList(fromTerm));
        fromClause.setSourceLocation(var.getSourceLocation());
        VariableExpr returnExpr = new VariableExpr(var.getVar());
        returnExpr.setIsNewVar(false);
        returnExpr.setSourceLocation(var.getSourceLocation());
        SelectElement selectElement = new SelectElement((Expression)returnExpr);
        selectElement.setSourceLocation(stmtCopy.getSourceLocation());
        SelectClause selectClause = new SelectClause(selectElement, null, false);
        selectClause.setSourceLocation(stmtCopy.getSourceLocation());
        SelectBlock selectBlock = new SelectBlock(selectClause, fromClause, null, null, null);
        selectBlock.setSourceLocation(var.getSourceLocation());
        SelectSetOperation selectSetOperation = new SelectSetOperation(new SetOperationInput(selectBlock, null), null);
        selectSetOperation.setSourceLocation(var.getSourceLocation());
        SelectExpression selectExpression = new SelectExpression(null, selectSetOperation, null, null, false);
        selectExpression.setSourceLocation(var.getSourceLocation());
        Query query = new Query(false, false, (Expression)selectExpression, 0);
        query.setBody((Expression)selectExpression);
        query.setSourceLocation(stmtCopy.getSourceLocation());
        stmtCopy.setQuery(query);
    }
}

