/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.LoadStatement;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppAstVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Quadruple;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SqlppSynonymRewriteVisitor
extends AbstractSqlppAstVisitor<Void, MetadataProvider> {
    public static final SqlppSynonymRewriteVisitor INSTANCE = new SqlppSynonymRewriteVisitor();

    private SqlppSynonymRewriteVisitor() {
    }

    public Void visit(LoadStatement loadStmt, MetadataProvider metadataProvider) throws CompilationException {
        Quadruple<DataverseName, String, Boolean, String> dsName = this.resolveDatasetNameUsingSynonyms(metadataProvider, loadStmt.getDatabaseName(), loadStmt.getDataverseName(), loadStmt.getDatasetName(), false, loadStmt.getSourceLocation());
        if (dsName != null) {
            loadStmt.setNamespace(new Namespace((String)dsName.getFourth(), (DataverseName)dsName.getFirst()));
            loadStmt.setDatasetName((String)dsName.getSecond());
        }
        return null;
    }

    public Void visit(InsertStatement insertStmt, MetadataProvider metadataProvider) throws CompilationException {
        Quadruple<DataverseName, String, Boolean, String> dsName = this.resolveDatasetNameUsingSynonyms(metadataProvider, insertStmt.getDatabaseName(), insertStmt.getDataverseName(), insertStmt.getDatasetName(), false, insertStmt.getSourceLocation());
        if (dsName != null) {
            insertStmt.setNamespace(new Namespace((String)dsName.getFourth(), (DataverseName)dsName.getFirst()));
            insertStmt.setDatasetName((String)dsName.getSecond());
        }
        return null;
    }

    public Void visit(DeleteStatement deleteStmt, MetadataProvider metadataProvider) throws CompilationException {
        Quadruple<DataverseName, String, Boolean, String> dsName = this.resolveDatasetNameUsingSynonyms(metadataProvider, deleteStmt.getDatabaseName(), deleteStmt.getDataverseName(), deleteStmt.getDatasetName(), false, deleteStmt.getSourceLocation());
        if (dsName != null) {
            deleteStmt.setNamespace(new Namespace((String)dsName.getFourth(), (DataverseName)dsName.getFirst()));
            deleteStmt.setDatasetName((String)dsName.getSecond());
        }
        return null;
    }

    private Quadruple<DataverseName, String, Boolean, String> resolveDatasetNameUsingSynonyms(MetadataProvider metadataProvider, String databaseName, DataverseName dataverseName, String datasetName, boolean includingViews, SourceLocation sourceLoc) throws CompilationException {
        try {
            return metadataProvider.resolveDatasetNameUsingSynonyms(databaseName, dataverseName, datasetName, includingViews);
        }
        catch (AlgebricksException e) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, (Throwable)e, sourceLoc, new Serializable[]{e.getMessage()});
        }
    }
}

