/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public class EquivalentVariableExpressionComparatorVisitor
implements ILogicalExpressionVisitor<Boolean, ILogicalExpression> {
    public static final EquivalentVariableExpressionComparatorVisitor INSTANCE = new EquivalentVariableExpressionComparatorVisitor();

    private EquivalentVariableExpressionComparatorVisitor() {
    }

    @Override
    public Boolean visitConstantExpression(ConstantExpression expr, ILogicalExpression arg) throws AlgebricksException {
        return expr.equals(arg);
    }

    @Override
    public Boolean visitVariableReferenceExpression(VariableReferenceExpression expr, ILogicalExpression arg) throws AlgebricksException {
        if (arg.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitAggregateFunctionCallExpression(AggregateFunctionCallExpression expr, ILogicalExpression arg) throws AlgebricksException {
        return this.equals(expr, arg);
    }

    @Override
    public Boolean visitScalarFunctionCallExpression(ScalarFunctionCallExpression expr, ILogicalExpression arg) throws AlgebricksException {
        return this.equals(expr, arg);
    }

    @Override
    public Boolean visitStatefulFunctionCallExpression(StatefulFunctionCallExpression expr, ILogicalExpression arg) throws AlgebricksException {
        return this.equals(expr, arg);
    }

    @Override
    public Boolean visitUnnestingFunctionCallExpression(UnnestingFunctionCallExpression expr, ILogicalExpression arg) throws AlgebricksException {
        return this.equals(expr, arg);
    }

    public Boolean equals(AbstractFunctionCallExpression expr1, ILogicalExpression expr2) throws AlgebricksException {
        List<Mutable<ILogicalExpression>> fceArguments;
        if (!(expr2 instanceof AbstractFunctionCallExpression)) {
            return false;
        }
        AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr2;
        boolean equal = expr1.getFunctionIdentifier().equals(fce.getFunctionIdentifier());
        if (!equal) {
            return false;
        }
        List<Mutable<ILogicalExpression>> arguments = expr1.getArguments();
        int argumentCount = arguments.size();
        if (argumentCount != (fceArguments = fce.getArguments()).size()) {
            return false;
        }
        for (int i = 0; i < argumentCount; ++i) {
            ILogicalExpression fceArgument;
            ILogicalExpression argument = (ILogicalExpression)arguments.get(i).getValue();
            if (argument.accept(this, fceArgument = (ILogicalExpression)fceArguments.get(i).getValue()) != Boolean.FALSE) continue;
            return false;
        }
        return Arrays.deepEquals(expr1.getOpaqueParameters(), fce.getOpaqueParameters());
    }
}

