/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.utils;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.typecomputer.impl.RecordMergeTypeComputer;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class ProjectionFiltrationTypeUtil {
    public static final ARecordType ALL_FIELDS_TYPE = ProjectionFiltrationTypeUtil.createType("");
    public static final ARecordType EMPTY_TYPE = ProjectionFiltrationTypeUtil.createType("{}");

    private ProjectionFiltrationTypeUtil() {
    }

    public static ARecordType getRecordType(List<List<String>> paths) throws AlgebricksException {
        ARecordType result = EMPTY_TYPE;
        for (List<String> path : paths) {
            ARecordType type = ProjectionFiltrationTypeUtil.getPathRecordType(path);
            result = (ARecordType)RecordMergeTypeComputer.merge(result, type);
        }
        return new ARecordType("root", result.getFieldNames(), result.getFieldTypes(), true);
    }

    public static ARecordType getRecordTypeWithFieldTypes(List<List<String>> paths, List<IAType> types) throws AlgebricksException {
        ARecordType result = EMPTY_TYPE;
        for (int i = 0; i < paths.size(); ++i) {
            List<String> path = paths.get(i);
            ARecordType type = ProjectionFiltrationTypeUtil.getPathRecordType(path, types.get(i));
            result = (ARecordType)RecordMergeTypeComputer.merge(result, type);
        }
        return new ARecordType("root", result.getFieldNames(), result.getFieldTypes(), true);
    }

    public static ARecordType getPathRecordType(List<String> path) {
        return ProjectionFiltrationTypeUtil.getRecordType(path, "root", 0, BuiltinType.ANY);
    }

    public static ARecordType getMergedPathRecordType(ARecordType previousType, List<String> path, IAType leafType) throws AlgebricksException {
        ARecordType type = ProjectionFiltrationTypeUtil.getRecordType(path, "root", 0, leafType);
        if (previousType == EMPTY_TYPE) {
            return type;
        }
        return (ARecordType)RecordMergeTypeComputer.merge(previousType, type);
    }

    public static ARecordType getRecordType(List<List<String>> unnest, List<List<String>> project) throws AlgebricksException {
        IAType result = ProjectionFiltrationTypeUtil.getLeafType(project);
        for (int i = unnest.size() - 1; i >= 0; --i) {
            List<String> path = unnest.get(i);
            result = ProjectionFiltrationTypeUtil.getRecordType(path, "parent_" + i, 0, new AOrderedListType(result, "array_" + i));
        }
        return (ARecordType)result;
    }

    public static ARecordType merge(List<ARecordType> types) throws AlgebricksException {
        ARecordType result = types.get(0);
        for (int i = 1; i < types.size(); ++i) {
            result = (ARecordType)RecordMergeTypeComputer.merge(result, types.get(i));
        }
        return new ARecordType("root", result.getFieldNames(), result.getFieldTypes(), true);
    }

    public static IAType renameType(IAType type, String name) {
        return new RenamedType(type, name);
    }

    public static RenamedType renameType(IAType type, int index) {
        return new RenamedType(type, String.valueOf(index), index);
    }

    private static ARecordType getPathRecordType(List<String> path, IAType type) {
        return ProjectionFiltrationTypeUtil.getRecordType(path, "root", 0, type);
    }

    private static IAType getType(String typeName, List<String> path, int fieldIndex, IAType leafType) {
        if (fieldIndex == path.size()) {
            return leafType;
        }
        return ProjectionFiltrationTypeUtil.getRecordType(path, typeName, fieldIndex, leafType);
    }

    private static ARecordType getRecordType(List<String> path, String typeName, int fieldIndex, IAType leafType) {
        String fieldName;
        String[] fieldNames = new String[1];
        IAType[] fieldTypes = new IAType[1];
        fieldNames[0] = fieldName = path.get(fieldIndex);
        fieldTypes[0] = ProjectionFiltrationTypeUtil.getType(ProjectionFiltrationTypeUtil.getTypeName(fieldName), path, fieldIndex + 1, leafType);
        return new ARecordType(typeName, fieldNames, fieldTypes, true);
    }

    private static IAType getLeafType(List<List<String>> project) throws AlgebricksException {
        IAType itemType = project.isEmpty() || project.get(0) == null ? BuiltinType.ANY : ProjectionFiltrationTypeUtil.getRecordType(project);
        return itemType;
    }

    private static String getTypeName(String fieldName) {
        return fieldName + "_Type";
    }

    private static ARecordType createType(String typeName) {
        return new ARecordType(typeName, new String[0], new IAType[0], true);
    }

    public static class RenamedType
    implements IAType {
        private static final long serialVersionUID = 992690669300951839L;
        private final IAType originalType;
        private final String name;
        private final int index;

        RenamedType(IAType originalType, String name) {
            this(originalType, name, -1);
        }

        RenamedType(IAType originalType, String name, int index) {
            this.originalType = originalType;
            this.name = name;
            this.index = index;
        }

        @Override
        public IAType getType() {
            return this.originalType.getType();
        }

        @Override
        public boolean deepEqual(IAObject obj) {
            return this.originalType.deepEqual(obj);
        }

        public boolean equals(Object obj) {
            if (obj instanceof RenamedType) {
                return this.originalType.equals(((RenamedType)obj).originalType);
            }
            return this.originalType.equals(obj);
        }

        @Override
        public int hash() {
            return this.originalType.hash();
        }

        @Override
        public ATypeTag getTypeTag() {
            return this.originalType.getTypeTag();
        }

        @Override
        public String getDisplayName() {
            return this.originalType.getDisplayName();
        }

        @Override
        public String getTypeName() {
            return this.name;
        }

        @Override
        public <R, T> R accept(IATypeVisitor<R, T> visitor, T arg) {
            return visitor.visitFlat(this, arg);
        }

        public ObjectNode toJSON() {
            return this.originalType.toJSON();
        }

        public String toString() {
            return this.originalType.toString();
        }

        public int getIndex() {
            return this.index;
        }
    }
}

