/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve;

import java.io.IOException;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.AsterixTypeToParquetTypeVisitor;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.AbstractComplexConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.BinaryConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.DateConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.DecimalConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.GenericPrimitiveConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.JsonStringConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.MissingConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.TimeConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.TimestampConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.UUIDConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.UnsignedIntegerConverter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class PrimitiveConverterProvider {
    public static final PrimitiveType MISSING = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named("MISSING");

    private PrimitiveConverterProvider() {
    }

    public static PrimitiveConverter createPrimitiveConverter(PrimitiveType type, AbstractComplexConverter parent, int index, ParquetConverterContext context) throws IOException {
        return PrimitiveConverterProvider.createPrimitiveConverter(type, parent, null, index, context);
    }

    public static PrimitiveConverter createPrimitiveConverter(PrimitiveType type, AbstractComplexConverter parent, String stringFieldName, int index, ParquetConverterContext context) throws IOException {
        if (type == MISSING) {
            return MissingConverter.INSTANCE;
        }
        ATypeTag mappedType = AsterixTypeToParquetTypeVisitor.mapType((Type)type, context, null);
        switch (mappedType) {
            case BOOLEAN: 
            case STRING: {
                return new GenericPrimitiveConverter(mappedType, parent, stringFieldName, index, context);
            }
            case BIGINT: {
                return PrimitiveConverterProvider.getIntConverter(mappedType, type, parent, stringFieldName, index, context);
            }
            case DOUBLE: {
                return PrimitiveConverterProvider.getDoubleConverter(mappedType, type, parent, stringFieldName, index, context);
            }
            case BINARY: {
                return new BinaryConverter(parent, stringFieldName, index, context);
            }
            case UUID: {
                return new UUIDConverter(parent, stringFieldName, index, context);
            }
            case DATE: {
                return new DateConverter(parent, stringFieldName, index, context);
            }
            case TIME: {
                return PrimitiveConverterProvider.getTimeConverter(type, parent, stringFieldName, index, context);
            }
            case DATETIME: {
                return PrimitiveConverterProvider.getTimeStampConverter(type, parent, stringFieldName, index, context);
            }
            case ANY: {
                return new JsonStringConverter(parent, stringFieldName, index, context);
            }
        }
        return MissingConverter.INSTANCE;
    }

    private static PrimitiveConverter getIntConverter(ATypeTag typeTag, PrimitiveType type, AbstractComplexConverter parent, String stringFieldName, int index, ParquetConverterContext context) throws IOException {
        LogicalTypeAnnotation.IntLogicalTypeAnnotation intType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)type.getLogicalTypeAnnotation();
        if (intType != null && !intType.isSigned()) {
            return new UnsignedIntegerConverter(parent, stringFieldName, index, context);
        }
        return new GenericPrimitiveConverter(typeTag, parent, stringFieldName, index, context);
    }

    private static PrimitiveConverter getDoubleConverter(ATypeTag typeTag, PrimitiveType type, AbstractComplexConverter parent, String stringFieldName, int index, ParquetConverterContext context) throws IOException {
        LogicalTypeAnnotation logicalType = type.getLogicalTypeAnnotation();
        if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType;
            return new DecimalConverter(parent, stringFieldName, index, context, decimalLogicalType.getPrecision(), decimalLogicalType.getScale());
        }
        return new GenericPrimitiveConverter(typeTag, parent, stringFieldName, index, context);
    }

    private static PrimitiveConverter getTimeConverter(PrimitiveType type, AbstractComplexConverter parent, String stringFieldName, int index, ParquetConverterContext context) throws IOException {
        LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)type.getLogicalTypeAnnotation();
        return new TimeConverter(parent, stringFieldName, index, context, timeLogicalType.getUnit());
    }

    private static PrimitiveConverter getTimeStampConverter(PrimitiveType type, AbstractComplexConverter parent, String stringFieldName, int index, ParquetConverterContext context) throws IOException {
        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation tsType = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)type.getLogicalTypeAnnotation();
        if (tsType != null) {
            int offset = tsType.isAdjustedToUTC() ? context.getTimeZoneOffset() : 0;
            return new TimestampConverter(parent, stringFieldName, index, context, tsType.getUnit(), offset);
        }
        return new TimestampConverter(parent, stringFieldName, index, context, LogicalTypeAnnotation.TimeUnit.MILLIS, 0);
    }
}

