/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud;

import java.io.IOException;
import org.apache.asterix.cloud.CloudResettableInputStream;
import org.apache.asterix.cloud.IWriteBufferProvider;
import org.apache.asterix.cloud.clients.ICloudBufferedWriter;
import org.apache.asterix.cloud.clients.ICloudClient;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.control.nc.io.FileHandle;

public class CloudFileHandle
extends FileHandle {
    private final CloudResettableInputStream inputStream;

    public CloudFileHandle(ICloudClient cloudClient, String bucket, FileReference fileRef, IWriteBufferProvider bufferProvider) {
        super(fileRef);
        ICloudBufferedWriter bufferedWriter = cloudClient.createBufferedWriter(bucket, fileRef.getRelativePath());
        this.inputStream = new CloudResettableInputStream(bufferedWriter, bufferProvider);
    }

    public void open(IIOManager.FileReadWriteMode rwMode, IIOManager.FileSyncMode syncMode) throws IOException {
        if (this.fileRef.getFile().exists()) {
            super.open(rwMode, syncMode);
        }
    }

    public synchronized void close() throws IOException {
        this.inputStream.close();
        super.close();
    }

    public CloudResettableInputStream getInputStream() {
        return this.inputStream;
    }
}

