/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.cloud.AbstractCloudIOManager;
import org.apache.asterix.cloud.CloudFileHandle;
import org.apache.asterix.cloud.bulk.DeleteBulkCloudOperation;
import org.apache.asterix.cloud.clients.IParallelDownloader;
import org.apache.asterix.cloud.lazy.ParallelCacher;
import org.apache.asterix.cloud.lazy.accessor.ILazyAccessor;
import org.apache.asterix.cloud.lazy.accessor.ILazyAccessorReplacer;
import org.apache.asterix.cloud.lazy.accessor.InitialCloudAccessor;
import org.apache.asterix.cloud.lazy.accessor.LocalAccessor;
import org.apache.asterix.cloud.lazy.accessor.ReplaceableCloudAccessor;
import org.apache.asterix.common.api.INamespacePathResolver;
import org.apache.asterix.common.config.CloudProperties;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOBulkOperation;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class LazyCloudIOManager
extends AbstractCloudIOManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ILazyAccessorReplacer replacer;
    private ILazyAccessor accessor;

    public LazyCloudIOManager(IOManager ioManager, CloudProperties cloudProperties, INamespacePathResolver nsPathResolver) throws HyracksDataException {
        super(ioManager, cloudProperties, nsPathResolver);
        this.accessor = new InitialCloudAccessor(this.cloudClient, this.bucket, this.localIoManager);
        this.replacer = () -> {
            LazyCloudIOManager lazyCloudIOManager = this;
            synchronized (lazyCloudIOManager) {
                if (!this.accessor.isLocalAccessor()) {
                    LOGGER.warn("Replacing cloud-accessor to local-accessor");
                    this.accessor = new LocalAccessor(this.cloudClient, this.bucket, this.localIoManager);
                }
            }
        };
    }

    @Override
    protected synchronized void downloadPartitions(boolean metadataNode, int metadataPartition) throws HyracksDataException {
        Set<String> cloudFiles = this.cloudClient.listObjects(this.bucket, "storage", IoUtil.NO_OP_FILTER).stream().filter(f -> this.partitions.contains(StoragePathUtil.getPartitionNumFromRelativePath((String)f))).collect(Collectors.toSet());
        HashSet<String> localFiles = new HashSet<String>();
        for (IODeviceHandle deviceHandle : this.getIODevices()) {
            FileReference storageRoot = deviceHandle.createFileRef("storage");
            Set deviceFiles = this.localIoManager.list(storageRoot, IoUtil.NO_OP_FILTER);
            for (FileReference fileReference : deviceFiles) {
                localFiles.add(fileReference.getRelativePath());
            }
        }
        cloudFiles.removeAll(localFiles);
        int remainingUncachedFiles = cloudFiles.size();
        if (remainingUncachedFiles > 0) {
            LOGGER.debug("The number of uncached files: {}. Uncached files: {}", (Object)remainingUncachedFiles, cloudFiles);
            List<FileReference> uncachedFiles = this.resolve(cloudFiles);
            IParallelDownloader downloader = this.cloudClient.createParallelDownloader(this.bucket, this.localIoManager);
            this.downloadMetadataPartition(downloader, uncachedFiles, metadataNode, metadataPartition);
            this.downloadMetadataFiles(downloader, uncachedFiles);
            ParallelCacher cacher = new ParallelCacher(downloader, uncachedFiles);
            this.accessor = new ReplaceableCloudAccessor(this.cloudClient, this.bucket, this.localIoManager, this.partitions, this.replacer, cacher);
        } else {
            this.accessor = new LocalAccessor(this.cloudClient, this.bucket, this.localIoManager);
        }
    }

    private void downloadMetadataPartition(IParallelDownloader downloader, List<FileReference> uncachedFiles, boolean metadataNode, int metadataPartition) throws HyracksDataException {
        String partitionDir = "partition_" + metadataPartition;
        if (metadataNode && uncachedFiles.stream().anyMatch(f -> f.getRelativePath().contains(partitionDir))) {
            LOGGER.debug("Downloading metadata partition {}, Current uncached files: {}", (Object)metadataPartition, uncachedFiles);
            FileReference metadataDir = this.resolve("storage" + File.separator + partitionDir);
            downloader.downloadDirectories(Collections.singleton(metadataDir));
            uncachedFiles.removeIf(f -> f.getRelativePath().contains(partitionDir));
            LOGGER.debug("Finished downloading metadata partition. Current uncached files: {}", uncachedFiles);
        }
    }

    @Override
    protected void onOpen(CloudFileHandle fileHandle, IIOManager.FileReadWriteMode rwMode, IIOManager.FileSyncMode syncMode) throws HyracksDataException {
        this.accessor.doOnOpen(fileHandle, rwMode, syncMode);
    }

    @Override
    public IIOBulkOperation createDeleteBulkOperation() {
        return new DeleteBulkCloudOperation(this.localIoManager, this.bucket, this.cloudClient, this.accessor.getBulkOperationCallBack());
    }

    public Set<FileReference> list(FileReference dir, FilenameFilter filter) throws HyracksDataException {
        return this.accessor.doList(dir, filter);
    }

    public boolean exists(FileReference fileRef) throws HyracksDataException {
        return this.accessor.doExists(fileRef);
    }

    public long getSize(FileReference fileReference) throws HyracksDataException {
        return this.accessor.doGetSize(fileReference);
    }

    public byte[] readAllBytes(FileReference fileRef) throws HyracksDataException {
        return this.accessor.doReadAllBytes(fileRef);
    }

    public void delete(FileReference fileRef) throws HyracksDataException {
        this.accessor.doDelete(fileRef);
        this.log("DELETE", fileRef);
    }

    public void overwrite(FileReference fileRef, byte[] bytes) throws HyracksDataException {
        this.accessor.doOverwrite(fileRef, bytes);
        this.log("WRITE", fileRef);
    }

    private List<FileReference> resolve(Set<String> cloudFiles) throws HyracksDataException {
        ArrayList<FileReference> fileReferences = new ArrayList<FileReference>();
        for (String file : cloudFiles) {
            fileReferences.add(this.resolve(file));
        }
        return fileReferences;
    }

    private void log(String op, FileReference fileReference) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} {}", (Object)op, (Object)fileReference.getRelativePath());
        }
    }

    private void downloadMetadataFiles(IParallelDownloader downloader, List<FileReference> uncachedFiles) throws HyracksDataException {
        Set<FileReference> uncachedMetadataFiles = ParallelCacher.getFiles(uncachedFiles, ParallelCacher.METADATA_FILTER);
        if (!uncachedMetadataFiles.isEmpty()) {
            LOGGER.debug("Downloading metadata files for all partitions; current uncached files: {}", uncachedFiles);
            downloader.downloadFiles(uncachedMetadataFiles);
            uncachedFiles.removeAll(uncachedMetadataFiles);
            LOGGER.debug("Finished downloading metadata files for all partitions. Current uncached files: {}", uncachedFiles);
        } else {
            LOGGER.debug("all metadata files for all partitions are already cached; current uncached files: {} ", uncachedFiles);
        }
    }
}

