/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.algebra.operators.physical;

import java.util.List;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourcePropertiesProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractScanPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.BroadcastPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;

public class ExternalDataLookupPOperator
extends AbstractScanPOperator {
    private final List<LogicalVariable> ridVarList;
    private DataSourceId datasetId;
    private Dataset dataset;
    private ARecordType recordType;
    private boolean requiresBroadcast;
    private boolean retainInput;
    private boolean retainMissing;

    public ExternalDataLookupPOperator(DataSourceId datasetId, Dataset dataset, ARecordType recordType, List<LogicalVariable> ridVarList, boolean requiresBroadcast, boolean retainInput, boolean retainMissing) {
        this.datasetId = datasetId;
        this.dataset = dataset;
        this.recordType = recordType;
        this.ridVarList = ridVarList;
        this.requiresBroadcast = requiresBroadcast;
        this.retainInput = retainInput;
        this.retainMissing = retainMissing;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public ARecordType getRecordType() {
        return this.recordType;
    }

    public void setRecordType(ARecordType recordType) {
        this.recordType = recordType;
    }

    public DataSourceId getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(DataSourceId datasetId) {
        this.datasetId = datasetId;
    }

    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.EXTERNAL_LOOKUP;
    }

    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        DatasetDataSource ds = new DatasetDataSource(this.datasetId, this.dataset, (IAType)this.recordType, null, 1, this.dataset.getDatasetDetails(), context.getComputationNodeDomain());
        IDataSourcePropertiesProvider dspp = ds.getPropertiesProvider();
        AbstractScanOperator as = (AbstractScanOperator)op;
        this.deliveredProperties = dspp.computeDeliveredProperties(as.getVariables(), context);
    }

    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema opSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        UnnestMapOperator unnestMap = (UnnestMapOperator)op;
        ILogicalExpression expr = (ILogicalExpression)unnestMap.getExpressionRef().getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            throw new IllegalStateException();
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        FunctionIdentifier funcIdent = funcExpr.getFunctionIdentifier();
        if (!funcIdent.equals((Object)BuiltinFunctions.EXTERNAL_LOOKUP)) {
            return;
        }
        int[] ridIndexes = this.getKeyIndexes(this.ridVarList, inputSchemas);
        IVariableTypeEnvironment typeEnv = context.getTypeEnvironment(op);
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        Pair externalLoopup = metadataProvider.buildExternalDataLookupRuntime(builder.getJobSpec(), this.dataset, ridIndexes, this.retainInput, typeEnv, opSchema, context, metadataProvider, this.retainMissing);
        IOperatorDescriptor opDesc = (IOperatorDescriptor)externalLoopup.first;
        opDesc.setSourceLocation(unnestMap.getSourceLocation());
        builder.contributeHyracksOperator((ILogicalOperator)unnestMap, opDesc);
        builder.contributeAlgebricksPartitionConstraint(opDesc, (AlgebricksPartitionConstraint)externalLoopup.second);
        ILogicalOperator srcExchange = (ILogicalOperator)((Mutable)unnestMap.getInputs().get(0)).getValue();
        builder.contributeGraphEdge(srcExchange, 0, (ILogicalOperator)unnestMap, 0);
    }

    protected int[] getKeyIndexes(List<LogicalVariable> keyVarList, IOperatorSchema[] inputSchemas) {
        if (keyVarList == null) {
            return null;
        }
        int[] keyIndexes = new int[keyVarList.size()];
        for (int i = 0; i < keyVarList.size(); ++i) {
            keyIndexes[i] = inputSchemas[0].findVariable(keyVarList.get(i));
        }
        return keyIndexes;
    }

    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) throws AlgebricksException {
        if (this.requiresBroadcast) {
            StructuralPropertiesVector[] pv = new StructuralPropertiesVector[]{new StructuralPropertiesVector((IPartitioningProperty)new BroadcastPartitioningProperty(null), null)};
            return new PhysicalRequirements((IPhysicalPropertiesVector[])pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
        }
        return super.getRequiredPropertiesForChildren(op, reqdByParent, context);
    }

    public boolean isMicroOperator() {
        return false;
    }
}

