/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.visitor;

import org.apache.asterix.metadata.utils.PushdownUtil;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.ScanDefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.schema.AbstractComplexExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.AnyExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaBuilder;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.RootExpectedSchemaNode;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public class ExpressionToExpectedSchemaNodeVisitor
implements ILogicalExpressionVisitor<IExpectedSchemaNode, Void> {
    private IVariableTypeEnvironment typeEnv;
    private ScanDefineDescriptor scanDefineDescriptor;

    public void reset(ScanDefineDescriptor scanDefineDescriptor) {
        this.scanDefineDescriptor = scanDefineDescriptor;
    }

    public void setTypeEnv(IVariableTypeEnvironment typeEnv) {
        this.typeEnv = typeEnv;
    }

    public IExpectedSchemaNode visitConstantExpression(ConstantExpression expr, Void arg) throws AlgebricksException {
        return null;
    }

    public IExpectedSchemaNode visitVariableReferenceExpression(VariableReferenceExpression expr, Void arg) throws AlgebricksException {
        LogicalVariable variable = VariableUtilities.getVariable((ILogicalExpression)expr);
        if (this.scanDefineDescriptor.getVariable() == variable || this.scanDefineDescriptor.getMetaRecordVariable() == variable) {
            return RootExpectedSchemaNode.ALL_FIELDS_ROOT_NODE;
        }
        return null;
    }

    public IExpectedSchemaNode visitScalarFunctionCallExpression(ScalarFunctionCallExpression expr, Void arg) throws AlgebricksException {
        return this.handleFunction((AbstractFunctionCallExpression)expr);
    }

    public IExpectedSchemaNode visitAggregateFunctionCallExpression(AggregateFunctionCallExpression expr, Void arg) throws AlgebricksException {
        return null;
    }

    public IExpectedSchemaNode visitStatefulFunctionCallExpression(StatefulFunctionCallExpression expr, Void arg) throws AlgebricksException {
        return null;
    }

    public IExpectedSchemaNode visitUnnestingFunctionCallExpression(UnnestingFunctionCallExpression expr, Void arg) throws AlgebricksException {
        return this.handleFunction((AbstractFunctionCallExpression)expr);
    }

    private IExpectedSchemaNode handleFunction(AbstractFunctionCallExpression expr) throws AlgebricksException {
        FunctionIdentifier fid = expr.getFunctionIdentifier();
        if (!PushdownUtil.FILTER_PUSHABLE_PATH_FUNCTIONS.contains(fid)) {
            return null;
        }
        ILogicalExpression parentExpr = (ILogicalExpression)((Mutable)expr.getArguments().get(0)).getValue();
        IExpectedSchemaNode parent = (IExpectedSchemaNode)parentExpr.accept((ILogicalExpressionVisitor)this, null);
        if (parent == null) {
            return null;
        }
        AbstractComplexExpectedSchemaNode newParent = this.replaceIfNeeded(parent, expr);
        AnyExpectedSchemaNode myNode = new AnyExpectedSchemaNode(newParent, expr.getSourceLocation(), expr.getFunctionIdentifier().getName());
        ExpectedSchemaBuilder.addChild(expr, this.typeEnv, newParent, myNode);
        return myNode;
    }

    private AbstractComplexExpectedSchemaNode replaceIfNeeded(IExpectedSchemaNode parent, AbstractFunctionCallExpression funcExpr) {
        ExpectedSchemaNodeType expectedType = ExpectedSchemaBuilder.getExpectedNestedNodeType(funcExpr);
        return (AbstractComplexExpectedSchemaNode)parent.replaceIfNeeded(expectedType, parent.getSourceLocation(), parent.getFunctionName());
    }
}

