/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;

public class KeyColumn {
    private final StaticBuffer key;
    private final StaticBuffer col;
    private int cachedHashCode;

    public KeyColumn(StaticBuffer key, StaticBuffer col) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)col);
        this.key = key;
        this.col = col;
        assert (null != this.key);
        assert (null != this.col);
    }

    public StaticBuffer getKey() {
        return this.key;
    }

    public StaticBuffer getColumn() {
        return this.col;
    }

    public int hashCode() {
        if (0 != this.cachedHashCode) {
            return this.cachedHashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.col.hashCode();
        this.cachedHashCode = result = 31 * result + this.key.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyColumn other = (KeyColumn)obj;
        return other.key.equals(this.key) && other.col.equals(this.col);
    }

    public String toString() {
        return "KeyColumn [k=0x" + this.key.toString() + ", c=0x" + this.col.toString() + "]";
    }
}

