/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.OrderPreservingSerializer;

public class ByteSerializer
implements OrderPreservingSerializer<Byte> {
    private static final long serialVersionUID = 117423419883604186L;

    @Override
    public Byte read(ScanBuffer buffer) {
        return (byte)(buffer.getByte() + -128);
    }

    @Override
    public void write(WriteBuffer out, Byte object) {
        out.putByte((byte)(object - -128));
    }

    @Override
    public Byte readByteOrder(ScanBuffer buffer) {
        return this.read(buffer);
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, Byte attribute) {
        this.write(buffer, attribute);
    }

    @Override
    public void verifyAttribute(Byte value) {
    }

    @Override
    public Byte convert(Object value) {
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            if (Double.isNaN(d) || (double)Math.round(d) != d) {
                throw new IllegalArgumentException("Not a valid byte: " + value);
            }
            long l = ((Number)value).longValue();
            if (l >= -128L && l <= 127L) {
                return (byte)l;
            }
            throw new IllegalArgumentException("Value too large for byte: " + value);
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        return null;
    }
}

