/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.OrderPreservingSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.ShortSerializer;

public class CharacterSerializer
implements OrderPreservingSerializer<Character> {
    private final ShortSerializer ss = new ShortSerializer();

    @Override
    public Character read(ScanBuffer buffer) {
        short s = this.ss.read(buffer);
        return Character.valueOf(CharacterSerializer.short2char(s));
    }

    @Override
    public void write(WriteBuffer out, Character attribute) {
        this.ss.write(out, CharacterSerializer.char2short(attribute.charValue()));
    }

    @Override
    public Character readByteOrder(ScanBuffer buffer) {
        return this.read(buffer);
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, Character attribute) {
        this.write(buffer, attribute);
    }

    public static final short char2short(char c) {
        return (short)(c + Short.MIN_VALUE);
    }

    public static final char short2char(short s) {
        return (char)(s - Short.MIN_VALUE);
    }

    @Override
    public void verifyAttribute(Character value) {
    }

    @Override
    public Character convert(Object value) {
        if (value instanceof String && ((String)value).length() == 1) {
            return Character.valueOf(((String)value).charAt(0));
        }
        return null;
    }
}

