/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.fulgora;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.olap.OLAPResult;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import java.util.Map;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;

public class FulgoraResult<S>
implements OLAPResult<S> {
    private NonBlockingHashMapLong<S> vertexStates;
    private final IDManager idManager;

    public FulgoraResult(int numVertices, IDManager idManager) {
        Preconditions.checkArgument((numVertices >= 0 ? 1 : 0) != 0);
        this.vertexStates = new NonBlockingHashMapLong(numVertices);
        this.idManager = idManager;
    }

    public FulgoraResult(Map<Long, S> initialState, IDManager idManager) {
        this(Math.max(initialState.size(), 0), idManager);
        for (Map.Entry<Long, S> entry : initialState.entrySet()) {
            long vertexId = entry.getKey();
            Preconditions.checkArgument((!idManager.isPartitionedVertex(vertexId) || vertexId == idManager.getCanonicalVertexId(vertexId) ? 1 : 0) != 0);
            this.vertexStates.put(vertexId, entry.getValue());
        }
    }

    void set(long vertexId, S state) {
        Preconditions.checkArgument((!this.idManager.isPartitionedVertex(vertexId) || vertexId == this.idManager.getCanonicalVertexId(vertexId) ? 1 : 0) != 0);
        this.vertexStates.put(vertexId, state);
    }

    @Override
    public Iterable<S> values() {
        return this.vertexStates.values();
    }

    @Override
    public Iterable<Map.Entry<Long, S>> entries() {
        return this.vertexStates.entrySet();
    }

    @Override
    public long size() {
        return this.vertexStates.size();
    }

    @Override
    public S get(long vertexId) {
        if (this.idManager.isPartitionedVertex(vertexId)) {
            vertexId = this.idManager.getCanonicalVertexId(vertexId);
        }
        return (S)this.vertexStates.get(vertexId);
    }
}

