/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.schema;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.compiler.schema.SchemaVisitor;
import org.apache.avro.compiler.schema.SchemaVisitorAction;
import org.apache.avro.compiler.specific.SpecificCompiler;

public final class Schemas {
    private Schemas() {
    }

    public static void copyAliases(Schema from, Schema to) {
        switch (from.getType()) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                Set aliases = from.getAliases();
                for (String alias : aliases) {
                    to.addAlias(alias);
                }
                break;
            }
        }
    }

    public static void copyAliases(Schema.Field from, Schema.Field to) {
        Set aliases = from.aliases();
        for (String alias : aliases) {
            to.addAlias(alias);
        }
    }

    public static void copyLogicalTypes(Schema from, Schema to) {
        LogicalType logicalType = from.getLogicalType();
        if (logicalType != null) {
            logicalType.addToSchema(to);
        }
    }

    public static void copyProperties(JsonProperties from, JsonProperties to) {
        Map objectProps = from.getObjectProps();
        for (Map.Entry entry : objectProps.entrySet()) {
            to.addProp((String)entry.getKey(), entry.getValue());
        }
    }

    public static boolean hasGeneratedJavaClass(Schema schema) {
        Schema.Type type = schema.getType();
        switch (type) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                return true;
            }
        }
        return false;
    }

    public static String getJavaClassName(Schema schema) {
        String namespace = schema.getNamespace();
        if (namespace == null) {
            return SpecificCompiler.mangle(schema.getName());
        }
        return namespace + '.' + SpecificCompiler.mangle(schema.getName());
    }

    public static <T> T visit(Schema start, SchemaVisitor<T> visitor) {
        Object current;
        IdentityHashMap<Schema, Schema> visited = new IdentityHashMap<Schema, Schema>();
        ArrayDeque<Object> dq = new ArrayDeque<Object>();
        dq.addLast(start);
        block13: while ((current = dq.pollLast()) != null) {
            boolean terminate;
            if (current instanceof Supplier) {
                SchemaVisitorAction action = (SchemaVisitorAction)((Object)((Supplier)current).get());
                switch (action) {
                    case CONTINUE: {
                        continue block13;
                    }
                    case SKIP_SUBTREE: {
                        throw new UnsupportedOperationException();
                    }
                    case SKIP_SIBLINGS: {
                        while (dq.getLast() instanceof Schema) {
                            dq.removeLast();
                        }
                        continue block13;
                    }
                    case TERMINATE: {
                        return visitor.get();
                    }
                }
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action));
            }
            Schema schema = (Schema)current;
            if (!visited.containsKey(schema)) {
                Schema.Type type = schema.getType();
                switch (type) {
                    case ARRAY: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, Collections.singleton(schema.getElementType()));
                        visited.put(schema, schema);
                        break;
                    }
                    case RECORD: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, () -> schema.getFields().stream().map(Schema.Field::schema).collect(Collectors.toCollection(ArrayDeque::new)).descendingIterator());
                        visited.put(schema, schema);
                        break;
                    }
                    case UNION: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, schema.getTypes());
                        visited.put(schema, schema);
                        break;
                    }
                    case MAP: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, Collections.singleton(schema.getValueType()));
                        visited.put(schema, schema);
                        break;
                    }
                    case ENUM: 
                    case FIXED: 
                    case NULL: 
                    case BOOLEAN: 
                    case BYTES: 
                    case DOUBLE: 
                    case FLOAT: 
                    case INT: 
                    case LONG: 
                    case STRING: {
                        terminate = Schemas.visitTerminal(visitor, schema, dq);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Invalid type " + type);
                    }
                }
            } else {
                terminate = Schemas.visitTerminal(visitor, schema, dq);
            }
            if (!terminate) continue;
            return visitor.get();
        }
        return visitor.get();
    }

    private static boolean visitNonTerminal(SchemaVisitor visitor, Schema schema, Deque<Object> dq, Iterable<Schema> itSupp) {
        SchemaVisitorAction action = visitor.visitNonTerminal(schema);
        switch (action) {
            case CONTINUE: {
                dq.addLast(() -> visitor.afterVisitNonTerminal(schema));
                for (Schema child : itSupp) {
                    dq.addLast(child);
                }
                break;
            }
            case SKIP_SUBTREE: {
                dq.addLast(() -> visitor.afterVisitNonTerminal(schema));
                break;
            }
            case SKIP_SIBLINGS: {
                while (!dq.isEmpty() && dq.getLast() instanceof Schema) {
                    dq.removeLast();
                }
                break;
            }
            case TERMINATE: {
                return true;
            }
            default: {
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action) + " for " + schema);
            }
        }
        return false;
    }

    private static boolean visitTerminal(SchemaVisitor visitor, Schema schema, Deque<Object> dq) {
        SchemaVisitorAction action = visitor.visitTerminal(schema);
        switch (action) {
            case CONTINUE: {
                break;
            }
            case SKIP_SUBTREE: {
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action) + " for " + schema);
            }
            case SKIP_SIBLINGS: {
                while (!dq.isEmpty() && dq.getLast() instanceof Schema) {
                    dq.removeLast();
                }
                break;
            }
            case TERMINATE: {
                return true;
            }
            default: {
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action) + " for " + schema);
            }
        }
        return false;
    }
}

