/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.trevni.Checksum;

final class Crc32Checksum
extends Checksum {
    private CRC32 crc32 = new CRC32();

    Crc32Checksum() {
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public ByteBuffer compute(ByteBuffer data) {
        this.crc32.reset();
        this.crc32.update(data.array(), data.position(), data.remaining());
        ByteBuffer result = ByteBuffer.allocate(this.size());
        result.putInt((int)this.crc32.getValue());
        ((Buffer)result).flip();
        return result;
    }
}

