/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;

public class ListFilesOnDiscCommand
extends BookieCommand<LFODFlags> {
    private static final String NAME = "listfilesondisc";
    private static final String DESC = "List the files in JournalDirectory/LedgerDirectories/IndexDirectories.";

    public ListFilesOnDiscCommand() {
        this(new LFODFlags());
    }

    public ListFilesOnDiscCommand(LFODFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, LFODFlags cmdFlags) {
        try {
            return this.handler(conf, cmdFlags);
        }
        catch (IOException e) {
            throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean handler(ServerConfiguration conf, LFODFlags cmd) throws IOException {
        if (cmd.journal) {
            File[] journalDirs = conf.getJournalDirs();
            List<File> journalFiles = BookieShell.listFilesAndSort(journalDirs, "txn");
            System.out.println("--------- Printing the list of Journal Files ---------");
            for (File journalFile : journalFiles) {
                System.out.println(journalFile.getCanonicalPath());
            }
            System.out.println();
        }
        if (cmd.entrylog) {
            File[] ledgerDirs = conf.getLedgerDirs();
            List<File> ledgerFiles = BookieShell.listFilesAndSort(ledgerDirs, "log");
            System.out.println("--------- Printing the list of EntryLog/Ledger Files ---------");
            for (File ledgerFile : ledgerFiles) {
                System.out.println(ledgerFile.getCanonicalPath());
            }
            System.out.println();
        }
        if (cmd.index) {
            File[] indexDirs = conf.getIndexDirs() == null ? conf.getLedgerDirs() : conf.getIndexDirs();
            List<File> indexFiles = BookieShell.listFilesAndSort(indexDirs, "idx");
            System.out.println("--------- Printing the list of Index Files ---------");
            for (File indexFile : indexFiles) {
                System.out.println(indexFile.getCanonicalPath());
            }
        }
        return true;
    }

    public static class LFODFlags
    extends CliFlags {
        @Parameter(names={"-txn", "--journal"}, description="Print list of Journal Files")
        private boolean journal;
        @Parameter(names={"-log", "--entrylog"}, description="Print list of EntryLog Files")
        private boolean entrylog;
        @Parameter(names={"-idx", "--index"}, description="Print list of Index Files")
        private boolean index;

        public LFODFlags journal(boolean journal) {
            this.journal = journal;
            return this;
        }

        public LFODFlags entrylog(boolean entrylog) {
            this.entrylog = entrylog;
            return this;
        }

        public LFODFlags index(boolean index) {
            this.index = index;
            return this;
        }
    }
}

