/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.web.sstore;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.ext.web.Session;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.web.sstore.SessionStore.class)
public class SessionStore {
    public static final TypeArg<SessionStore> __TYPE_ARG = new TypeArg(obj -> new SessionStore((io.vertx.ext.web.sstore.SessionStore)obj), SessionStore::getDelegate);
    private final io.vertx.ext.web.sstore.SessionStore delegate;

    public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
        this.delegate = delegate;
    }

    public io.vertx.ext.web.sstore.SessionStore getDelegate() {
        return this.delegate;
    }

    public long retryTimeout() {
        long ret = this.delegate.retryTimeout();
        return ret;
    }

    public Session createSession(long timeout) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout));
        return ret;
    }

    public Session createSession(long timeout, int length) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout, length));
        return ret;
    }

    public void get(String id, final Handler<AsyncResult<Session>> resultHandler) {
        this.delegate.get(id, new Handler<AsyncResult<io.vertx.ext.web.Session>>(){

            public void handle(AsyncResult<io.vertx.ext.web.Session> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)Session.newInstance((io.vertx.ext.web.Session)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    @Deprecated
    public Observable<Session> getObservable(String id) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.get(id, (Handler<AsyncResult<Session>>)resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Session> rxGet(String id) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.get(id, (Handler<AsyncResult<Session>>)fut)));
    }

    public void delete(String id, Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.delete(id, resultHandler);
    }

    @Deprecated
    public Observable<Boolean> deleteObservable(String id) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.delete(id, (Handler<AsyncResult<Boolean>>)resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Boolean> rxDelete(String id) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.delete(id, (Handler<AsyncResult<Boolean>>)fut)));
    }

    public void put(Session session, Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.put(session.getDelegate(), resultHandler);
    }

    @Deprecated
    public Observable<Boolean> putObservable(Session session) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.put(session, (Handler<AsyncResult<Boolean>>)resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Boolean> rxPut(Session session) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.put(session, (Handler<AsyncResult<Boolean>>)fut)));
    }

    public void clear(Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.clear(resultHandler);
    }

    @Deprecated
    public Observable<Boolean> clearObservable() {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.clear((Handler<AsyncResult<Boolean>>)resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Boolean> rxClear() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.clear((Handler<AsyncResult<Boolean>>)fut)));
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.delegate.size(resultHandler);
    }

    @Deprecated
    public Observable<Integer> sizeObservable() {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.size((Handler<AsyncResult<Integer>>)resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Integer> rxSize() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.size((Handler<AsyncResult<Integer>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public static SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
        return arg != null ? new SessionStore(arg) : null;
    }
}

