/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.zookeeper.AsyncCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieLedgerIndexer {
    private static final Logger LOG = LoggerFactory.getLogger(BookieLedgerIndexer.class);
    private final LedgerManager ledgerManager;

    public BookieLedgerIndexer(LedgerManager ledgerManager) {
        this.ledgerManager = ledgerManager;
    }

    public Map<String, Set<Long>> getBookieToLedgerIndex() throws ReplicationException.BKAuditException {
        final ConcurrentHashMap<String, Set<Long>> bookie2ledgersMap = new ConcurrentHashMap<String, Set<Long>>();
        final CountDownLatch ledgerCollectorLatch = new CountDownLatch(1);
        BookkeeperInternalCallbacks.Processor<Long> ledgerProcessor = new BookkeeperInternalCallbacks.Processor<Long>(){

            @Override
            public void process(Long ledgerId, AsyncCallback.VoidCallback iterCallback) {
                BookieLedgerIndexer.this.ledgerManager.readLedgerMetadata(ledgerId).whenComplete((metadata, exception) -> {
                    if (exception == null) {
                        for (Map.Entry ensemble : ((LedgerMetadata)metadata.getValue()).getAllEnsembles().entrySet()) {
                            for (BookieSocketAddress bookie : (List)ensemble.getValue()) {
                                BookieLedgerIndexer.this.putLedger(bookie2ledgersMap, bookie.toString(), ledgerId);
                            }
                        }
                        iterCallback.processResult(0, null, null);
                    } else if (BKException.getExceptionCode(exception) == -25) {
                        LOG.info("Ignoring replication of already deleted ledger {}", (Object)ledgerId);
                        iterCallback.processResult(0, null, null);
                    } else {
                        LOG.warn("Unable to read the ledger: {} information", (Object)ledgerId);
                        iterCallback.processResult(BKException.getExceptionCode(exception), null, null);
                    }
                });
            }
        };
        final ArrayList resultCode = new ArrayList(1);
        this.ledgerManager.asyncProcessLedgers(ledgerProcessor, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String s, Object obj) {
                resultCode.add(rc);
                ledgerCollectorLatch.countDown();
            }
        }, null, 0, -1);
        try {
            ledgerCollectorLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ReplicationException.BKAuditException("Exception while getting the bookie-ledgers", e);
        }
        if (!resultCode.contains(0)) {
            throw new ReplicationException.BKAuditException("Exception while getting the bookie-ledgers", BKException.create((Integer)resultCode.get(0)));
        }
        return bookie2ledgersMap;
    }

    private void putLedger(ConcurrentHashMap<String, Set<Long>> bookie2ledgersMap, String bookie, long ledgerId) {
        Set<Long> oldLedgers;
        Set<Long> ledgers = bookie2ledgersMap.get(bookie);
        if (ledgers == null && (oldLedgers = bookie2ledgersMap.putIfAbsent(bookie, ledgers = Collections.synchronizedSet(new HashSet()))) != null) {
            ledgers = oldLedgers;
        }
        ledgers.add(ledgerId);
    }
}

