/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal.api;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.NavigableMap;
import org.apache.bookkeeper.clients.impl.internal.api.HashStreamRanges;
import org.apache.bookkeeper.stream.proto.RangeKeyType;
import org.apache.bookkeeper.stream.proto.RangeProperties;

public abstract class StreamRanges<T> {
    private final RangeKeyType keyType;
    private final NavigableMap<T, RangeProperties> ranges;
    private final long maxRangeId;

    public static HashStreamRanges ofHash(RangeKeyType keyType, NavigableMap<Long, RangeProperties> ranges) {
        Preconditions.checkArgument((RangeKeyType.HASH == keyType ? 1 : 0) != 0, (String)"Only hash routing is supported now. %s is not supported.", (Object)((Object)keyType));
        NavigableMap<Long, RangeProperties> readOnlyRanges = Collections.unmodifiableNavigableMap(ranges);
        long maxRangeId = 0L;
        for (RangeProperties props : ranges.values()) {
            maxRangeId = Math.max(maxRangeId, props.getRangeId());
        }
        return new HashStreamRanges(readOnlyRanges, maxRangeId);
    }

    public RangeKeyType getKeyType() {
        return this.keyType;
    }

    public NavigableMap<T, RangeProperties> getRanges() {
        return this.ranges;
    }

    public long getMaxRangeId() {
        return this.maxRangeId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamRanges)) {
            return false;
        }
        StreamRanges other = (StreamRanges)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RangeKeyType this$keyType = this.getKeyType();
        RangeKeyType other$keyType = other.getKeyType();
        if (this$keyType == null ? other$keyType != null : !((Object)((Object)this$keyType)).equals((Object)other$keyType)) {
            return false;
        }
        NavigableMap<T, RangeProperties> this$ranges = this.getRanges();
        NavigableMap<T, RangeProperties> other$ranges = other.getRanges();
        if (this$ranges == null ? other$ranges != null : !this$ranges.equals(other$ranges)) {
            return false;
        }
        return this.getMaxRangeId() == other.getMaxRangeId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamRanges;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RangeKeyType $keyType = this.getKeyType();
        result = result * 59 + ($keyType == null ? 43 : ((Object)((Object)$keyType)).hashCode());
        NavigableMap<T, RangeProperties> $ranges = this.getRanges();
        result = result * 59 + ($ranges == null ? 43 : $ranges.hashCode());
        long $maxRangeId = this.getMaxRangeId();
        result = result * 59 + (int)($maxRangeId >>> 32 ^ $maxRangeId);
        return result;
    }

    public String toString() {
        return "StreamRanges(keyType=" + (Object)((Object)this.getKeyType()) + ", ranges=" + this.getRanges() + ", maxRangeId=" + this.getMaxRangeId() + ")";
    }

    public StreamRanges(RangeKeyType keyType, NavigableMap<T, RangeProperties> ranges, long maxRangeId) {
        this.keyType = keyType;
        this.ranges = ranges;
        this.maxRangeId = maxRangeId;
    }
}

