/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.channel;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.impl.container.StorageContainerClientInterceptor;
import org.apache.bookkeeper.clients.resolver.EndpointResolver;
import org.apache.bookkeeper.clients.utils.GrpcUtils;
import org.apache.bookkeeper.common.grpc.stats.MonitoringClientInterceptor;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.bookkeeper.stream.proto.kv.rpc.TableServiceGrpc;
import org.apache.bookkeeper.stream.proto.storage.MetaRangeServiceGrpc;
import org.apache.bookkeeper.stream.proto.storage.RootRangeServiceGrpc;
import org.apache.bookkeeper.stream.proto.storage.StorageContainerServiceGrpc;

public class StorageServerChannel
implements AutoCloseable {
    private final Optional<String> token;
    private final Channel channel;
    private final StorageServerChannel interceptedServerChannel;
    @GuardedBy(value="this")
    private RootRangeServiceGrpc.RootRangeServiceFutureStub rootRangeService;
    @GuardedBy(value="this")
    private MetaRangeServiceGrpc.MetaRangeServiceFutureStub metaRangeService;
    @GuardedBy(value="this")
    private StorageContainerServiceGrpc.StorageContainerServiceFutureStub scService;
    @GuardedBy(value="this")
    private TableServiceGrpc.TableServiceFutureStub kvService;

    public static Function<Endpoint, StorageServerChannel> factory(final StorageClientSettings settings) {
        return new Function<Endpoint, StorageServerChannel>(){
            private final Optional<MonitoringClientInterceptor> interceptor;
            {
                this.interceptor = settings.statsLogger().map(statsLogger -> MonitoringClientInterceptor.create(statsLogger, true));
            }

            @Override
            public StorageServerChannel apply(Endpoint endpoint) {
                StorageServerChannel channel = new StorageServerChannel(endpoint, Optional.empty(), settings.usePlaintext(), settings.endpointResolver());
                return this.interceptor.map(interceptor -> channel.intercept((ClientInterceptor)interceptor)).orElse(channel);
            }
        };
    }

    public StorageServerChannel(Endpoint endpoint, Optional<String> token, boolean usePlainText, EndpointResolver endpointResolver) {
        this.token = token;
        Endpoint resolvedEndpoint = endpointResolver.resolve(endpoint);
        this.channel = ManagedChannelBuilder.forAddress((String)resolvedEndpoint.getHostname(), (int)resolvedEndpoint.getPort()).usePlaintext(usePlainText).build();
        this.interceptedServerChannel = null;
    }

    public Channel getGrpcChannel() {
        return this.channel;
    }

    @VisibleForTesting
    public StorageServerChannel(ManagedChannel channel, Optional<String> token) {
        this((Channel)channel, token);
    }

    protected StorageServerChannel(Channel channel, Optional<String> token) {
        this(channel, token, null);
    }

    private StorageServerChannel(Channel channel, Optional<String> token, StorageServerChannel interceptedServerChannel) {
        this.token = token;
        this.channel = channel;
        this.interceptedServerChannel = interceptedServerChannel;
    }

    public synchronized RootRangeServiceGrpc.RootRangeServiceFutureStub getRootRangeService() {
        if (null == this.rootRangeService) {
            this.rootRangeService = GrpcUtils.configureGrpcStub(RootRangeServiceGrpc.newFutureStub(this.channel), this.token);
        }
        return this.rootRangeService;
    }

    public synchronized MetaRangeServiceGrpc.MetaRangeServiceFutureStub getMetaRangeService() {
        if (null == this.metaRangeService) {
            this.metaRangeService = GrpcUtils.configureGrpcStub(MetaRangeServiceGrpc.newFutureStub(this.channel), this.token);
        }
        return this.metaRangeService;
    }

    public synchronized StorageContainerServiceGrpc.StorageContainerServiceFutureStub getStorageContainerService() {
        if (null == this.scService) {
            this.scService = GrpcUtils.configureGrpcStub(StorageContainerServiceGrpc.newFutureStub(this.channel), this.token);
        }
        return this.scService;
    }

    public synchronized TableServiceGrpc.TableServiceFutureStub getTableService() {
        if (null == this.kvService) {
            this.kvService = GrpcUtils.configureGrpcStub(TableServiceGrpc.newFutureStub(this.channel), this.token);
        }
        return this.kvService;
    }

    public StorageServerChannel intercept(long scId) {
        return this.intercept(new StorageContainerClientInterceptor(scId));
    }

    public StorageServerChannel intercept(ClientInterceptor ... interceptors) {
        Channel interceptedChannel = ClientInterceptors.intercept((Channel)this.channel, (ClientInterceptor[])interceptors);
        return new StorageServerChannel(interceptedChannel, this.token, this);
    }

    @Override
    public void close() {
        if (this.interceptedServerChannel != null) {
            this.interceptedServerChannel.close();
        } else if (this.channel instanceof ManagedChannel) {
            ((ManagedChannel)this.channel).shutdown();
        }
    }
}

