/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint.dlog;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DLOutputStream
extends OutputStream {
    private static final Logger log = LoggerFactory.getLogger(DLOutputStream.class);
    private static final byte[] CONTROL_RECORD_CONTENT = "control".getBytes(StandardCharsets.UTF_8);
    private final DistributedLogManager dlm;
    private final AsyncLogWriter writer;
    private final long[] syncPos = new long[1];
    private long writePos = 0L;
    private static final AtomicReferenceFieldUpdater<DLOutputStream, Throwable> exceptionUpdater = AtomicReferenceFieldUpdater.newUpdater(DLOutputStream.class, Throwable.class, "exception");
    private volatile Throwable exception = null;

    DLOutputStream(DistributedLogManager dlm, AsyncLogWriter writer) {
        this.dlm = dlm;
        this.writer = writer;
        this.syncPos[0] = this.writePos = writer.getLastTxId() < 0L ? 0L : writer.getLastTxId();
    }

    public synchronized long position() {
        return this.syncPos[0];
    }

    @Override
    public void write(int b) throws IOException {
        byte[] data = new byte[]{(byte)b};
        this.write(data);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(Unpooled.wrappedBuffer((byte[])b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(Unpooled.wrappedBuffer((byte[])b, (int)off, (int)len));
    }

    private synchronized void write(ByteBuf buf) throws IOException {
        Throwable cause = exceptionUpdater.get(this);
        if (null != cause) {
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new UnexpectedException("Encountered unknown issue", cause);
        }
        this.writePos += (long)buf.readableBytes();
        final LogRecord record = new LogRecord(this.writePos, buf);
        this.writer.write(record).whenComplete((BiConsumer)new FutureEventListener<DLSN>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(DLSN value) {
                long[] lArray = DLOutputStream.this.syncPos;
                synchronized (lArray) {
                    ((DLOutputStream)DLOutputStream.this).syncPos[0] = record.getTransactionId();
                }
            }

            public void onFailure(Throwable cause) {
                exceptionUpdater.compareAndSet(DLOutputStream.this, null, cause);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<DLSN> writeControlRecord() {
        LogRecord record;
        DLOutputStream dLOutputStream = this;
        synchronized (dLOutputStream) {
            record = new LogRecord(this.writePos, Unpooled.wrappedBuffer((byte[])CONTROL_RECORD_CONTENT));
            record.setControl();
        }
        return this.writer.write(record);
    }

    @Override
    public void flush() throws IOException {
        try {
            FutureUtils.result(this.writeControlRecord());
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            log.error("Unexpected exception in DLOutputStream", (Throwable)e);
            throw new UnexpectedException("unexpected exception in DLOutputStream#flush()", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        Utils.ioResult((CompletableFuture)((CompletableFuture)this.writeControlRecord().thenCompose(ignored -> this.writer.asyncClose())).thenCompose(ignored -> this.dlm.asyncClose()));
    }
}

