/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.metric;

import java.util.Map;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.metric.AvgMinMaxCounterSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AvgMinMaxCounterSetTest
extends ZKTestCase {
    private AvgMinMaxCounterSet testCounterSet;

    @Before
    public void initCounter() {
        this.testCounterSet = new AvgMinMaxCounterSet("test");
    }

    private void addDataPoints() {
        this.testCounterSet.add("key1", 0L);
        this.testCounterSet.add("key1", 1L);
        this.testCounterSet.add("key2", 2L);
        this.testCounterSet.add("key2", 3L);
        this.testCounterSet.add("key2", 4L);
        this.testCounterSet.add("key2", 5L);
    }

    @Test
    public void testReset() {
        this.addDataPoints();
        this.testCounterSet.reset();
        Map values = this.testCounterSet.values();
        Assert.assertEquals((String)"There should be 10 values in the set", (long)10L, (long)values.size());
        Assert.assertEquals((String)"avg_key1_test should =0", (Object)0.0, values.get("avg_key1_test"));
        Assert.assertEquals((String)"min_key1_test should =0", (Object)0L, values.get("min_key1_test"));
        Assert.assertEquals((String)"max_key1_test should =0", (Object)0L, values.get("max_key1_test"));
        Assert.assertEquals((String)"cnt_key1_test should =0", (Object)0L, values.get("cnt_key1_test"));
        Assert.assertEquals((String)"sum_key1_test should =0", (Object)0L, values.get("sum_key1_test"));
        Assert.assertEquals((String)"avg_key2_test should =0", (Object)0.0, values.get("avg_key2_test"));
        Assert.assertEquals((String)"min_key2_test should =0", (Object)0L, values.get("min_key2_test"));
        Assert.assertEquals((String)"max_key2_test should =0", (Object)0L, values.get("max_key2_test"));
        Assert.assertEquals((String)"cnt_key2_test should =0", (Object)0L, values.get("cnt_key2_test"));
        Assert.assertEquals((String)"sum_key2_test should =0", (Object)0L, values.get("sum_key2_test"));
    }

    @Test
    public void testValues() {
        this.addDataPoints();
        Map values = this.testCounterSet.values();
        Assert.assertEquals((String)"There should be 10 values in the set", (long)10L, (long)values.size());
        Assert.assertEquals((String)"avg_key1_test should =0.5", (Object)0.5, values.get("avg_key1_test"));
        Assert.assertEquals((String)"min_key1_test should =0", (Object)0L, values.get("min_key1_test"));
        Assert.assertEquals((String)"max_key1_test should =1", (Object)1L, values.get("max_key1_test"));
        Assert.assertEquals((String)"cnt_key1_test should =2", (Object)2L, values.get("cnt_key1_test"));
        Assert.assertEquals((String)"sum_key1_test should =1", (Object)1L, values.get("sum_key1_test"));
        Assert.assertEquals((String)"avg_key2_test should =3.5", (Object)3.5, values.get("avg_key2_test"));
        Assert.assertEquals((String)"min_key2_test should =2", (Object)2L, values.get("min_key2_test"));
        Assert.assertEquals((String)"max_key2_test should =5", (Object)5L, values.get("max_key2_test"));
        Assert.assertEquals((String)"cnt_key2_test should =4", (Object)4L, values.get("cnt_key2_test"));
        Assert.assertEquals((String)"sum_key2_test should =14", (Object)14L, values.get("sum_key2_test"));
    }
}

