/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.command.FourLetterCommands;
import org.apache.zookeeper.server.command.StatCommand;
import org.apache.zookeeper.server.quorum.BufferStats;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class StatCommandTest {
    private StringWriter outputWriter;
    private StatCommand statCommand;
    private ServerStats.Provider providerMock;

    @Before
    public void setUp() {
        this.outputWriter = new StringWriter();
        ServerCnxn serverCnxnMock = (ServerCnxn)Mockito.mock(ServerCnxn.class);
        LeaderZooKeeperServer zks = (LeaderZooKeeperServer)Mockito.mock(LeaderZooKeeperServer.class);
        Mockito.when((Object)zks.isRunning()).thenReturn((Object)true);
        this.providerMock = (ServerStats.Provider)Mockito.mock(ServerStats.Provider.class);
        Mockito.when((Object)zks.serverStats()).thenReturn((Object)new ServerStats(this.providerMock));
        ZKDatabase zkDatabaseMock = (ZKDatabase)Mockito.mock(ZKDatabase.class);
        Mockito.when((Object)zks.getZKDatabase()).thenReturn((Object)zkDatabaseMock);
        Leader leaderMock = (Leader)Mockito.mock(Leader.class);
        Mockito.when((Object)leaderMock.getProposalStats()).thenReturn((Object)new BufferStats());
        Mockito.when((Object)zks.getLeader()).thenReturn((Object)leaderMock);
        ServerCnxnFactory serverCnxnFactory = (ServerCnxnFactory)Mockito.mock(ServerCnxnFactory.class);
        ServerCnxn serverCnxn = (ServerCnxn)Mockito.mock(ServerCnxn.class);
        ArrayList<ServerCnxn> connections = new ArrayList<ServerCnxn>();
        connections.add(serverCnxn);
        Mockito.when((Object)serverCnxnFactory.getConnections()).thenReturn(connections);
        this.statCommand = new StatCommand(new PrintWriter(this.outputWriter), serverCnxnMock, FourLetterCommands.statCmd);
        this.statCommand.setZkServer((ZooKeeperServer)zks);
        this.statCommand.setFactory(serverCnxnFactory);
    }

    @Test
    public void testLeaderStatCommand() {
        Mockito.when((Object)this.providerMock.getState()).thenReturn((Object)"leader");
        this.statCommand.commandRun();
        String output = this.outputWriter.toString();
        this.assertCommonStrings(output);
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Mode: leader"));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Proposal sizes last/min/max:"));
    }

    @Test
    public void testFollowerStatCommand() {
        Mockito.when((Object)this.providerMock.getState()).thenReturn((Object)"follower");
        this.statCommand.commandRun();
        String output = this.outputWriter.toString();
        this.assertCommonStrings(output);
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Mode: follower"));
    }

    private void assertCommonStrings(String output) {
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Clients:"));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Zookeeper version:"));
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"Node count:"));
    }
}

