/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import org.apache.zookeeper.server.util.CircularBuffer;
import org.junit.Assert;
import org.junit.Test;

public class CircularBufferTest {
    @Test
    public void testCircularBuffer() {
        int capacity = 3;
        CircularBuffer buffer = new CircularBuffer(String.class, 3);
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"A");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"B");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"C");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        Assert.assertEquals((Object)"A", (Object)buffer.take());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((Object)"B", (Object)buffer.take());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((Object)"C", (Object)buffer.take());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"1");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"2");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"3");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        buffer.write((Object)"4");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        Assert.assertEquals((Object)"2", (Object)buffer.take());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((Object)"3", (Object)buffer.take());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((Object)"4", (Object)buffer.take());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"a");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"b");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"c");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        buffer.write((Object)"d");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        buffer.write((Object)"e");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        buffer.write((Object)"f");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        buffer.write((Object)"g");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        Assert.assertEquals((Object)"e", (Object)buffer.take());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((Object)"f", (Object)buffer.take());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((Object)"g", (Object)buffer.take());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
    }

    @Test
    public void testCircularBufferWithCapacity1() {
        boolean capacity = true;
        CircularBuffer buffer = new CircularBuffer(String.class, 1);
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"A");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        buffer.write((Object)"B");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertTrue((boolean)buffer.isFull());
        Assert.assertEquals((Object)"B", (Object)buffer.take());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
    }

    @Test
    public void testCircularBufferReset() {
        int capacity = 3;
        CircularBuffer buffer = new CircularBuffer(String.class, 3);
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"A");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((long)1L, (long)buffer.size());
        Assert.assertEquals((Object)"A", (Object)buffer.peek());
        buffer.write((Object)"B");
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((long)2L, (long)buffer.size());
        Assert.assertEquals((Object)"A", (Object)buffer.peek());
        buffer.reset();
        Assert.assertNull((Object)buffer.peek());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertEquals((long)0L, (long)buffer.size());
    }

    @Test
    public void testCircularBufferIllegalCapacity() {
        try {
            CircularBuffer buffer = new CircularBuffer(String.class, 0);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"CircularBuffer capacity should be greater than 0", (Object)e.getMessage());
        }
    }
}

