/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands.table;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.api.StorageClient;
import org.apache.bookkeeper.api.kv.Table;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stream.cli.commands.ClientCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;

public class DelCommand
extends ClientCommand<Flags> {
    private static final String NAME = "del";
    private static final String DESC = "Put key/value pair to a table";

    public DelCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new Flags()).withArgumentsUsage("<table> <key> <value>").build());
    }

    @Override
    protected void run(StorageClient client, Flags flags) throws Exception {
        Preconditions.checkArgument((flags.arguments.size() >= 2 ? 1 : 0) != 0, (Object)"table and key/value are not provided");
        String tableName = (String)flags.arguments.get(0);
        String key = (String)flags.arguments.get(1);
        try (Table table = (Table)FutureUtils.result((CompletableFuture)client.openTable(tableName));){
            ByteBuf value = (ByteBuf)FutureUtils.result((CompletableFuture)table.delete((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8))));
            if (null != value) {
                value.release();
                this.spec.console().println("Successfully deleted key: ('" + key + "').");
            } else {
                this.spec.console().println("key '" + key + "' doesn't exist.");
            }
        }
    }

    public static class Flags
    extends CliFlags {
    }
}

