/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ChannelLogger;
import io.grpc.InternalChannelz;
import io.grpc.SecurityLevel;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.alts.internal.NettyTsiHandshaker;
import io.grpc.alts.internal.TsiFrameHandler;
import io.grpc.alts.internal.TsiFrameProtector;
import io.grpc.alts.internal.TsiPeer;
import io.grpc.internal.GrpcAttributes;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.annotation.Nullable;

public final class TsiHandshakeHandler
extends ByteToMessageDecoder {
    private static final int HANDSHAKE_FRAME_SIZE = 1024;
    private final NettyTsiHandshaker handshaker;
    private final HandshakeValidator handshakeValidator;
    private final ChannelHandler next;
    private ProtocolNegotiationEvent pne;

    public TsiHandshakeHandler(ChannelHandler next, NettyTsiHandshaker handshaker, HandshakeValidator handshakeValidator) {
        this.handshaker = (NettyTsiHandshaker)Preconditions.checkNotNull((Object)handshaker, (Object)"handshaker");
        this.handshakeValidator = (HandshakeValidator)Preconditions.checkNotNull((Object)handshakeValidator, (Object)"handshakeValidator");
        this.next = (ChannelHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
    }

    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        this.decode(ctx, in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.handshaker.processBytesFromPeer(in) && this.handshaker.isInProgress()) {
            this.sendHandshake(ctx);
        }
        if (!this.handshaker.isInProgress()) {
            TsiPeer peer = this.handshaker.extractPeer();
            Object authContext = this.handshaker.extractPeerObject();
            HandshakeValidator.SecurityDetails details = this.handshakeValidator.validatePeerObject(authContext);
            TsiFrameProtector protector = this.handshaker.createFrameProtector(ctx.alloc());
            boolean success = false;
            try {
                TsiFrameHandler framer = new TsiFrameHandler(protector);
                ctx.pipeline().addAfter(ctx.name(), null, (ChannelHandler)framer);
                ctx.pipeline().addAfter(ctx.pipeline().context((ChannelHandler)framer).name(), null, this.next);
                ctx.pipeline().remove(ctx.name());
                this.fireProtocolNegotiationEvent(ctx, peer, authContext, details);
                success = true;
            }
            finally {
                if (!success && protector != null) {
                    protector.destroy();
                }
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ProtocolNegotiationEvent) {
            Preconditions.checkState((this.pne == null ? 1 : 0) != 0, (Object)"negotiation already started");
            this.pne = (ProtocolNegotiationEvent)evt;
            InternalProtocolNegotiators.negotiationLogger((ChannelHandlerContext)ctx).log(ChannelLogger.ChannelLogLevel.INFO, "TsiHandshake started");
            this.sendHandshake(ctx);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    private void fireProtocolNegotiationEvent(ChannelHandlerContext ctx, TsiPeer peer, Object authContext, HandshakeValidator.SecurityDetails details) {
        Preconditions.checkState((this.pne != null ? 1 : 0) != 0, (Object)"negotiation not yet complete");
        InternalProtocolNegotiators.negotiationLogger((ChannelHandlerContext)ctx).log(ChannelLogger.ChannelLogLevel.INFO, "TsiHandshake finished");
        ProtocolNegotiationEvent localPne = this.pne;
        Attributes.Builder attrs = InternalProtocolNegotiationEvent.getAttributes((ProtocolNegotiationEvent)localPne).toBuilder().set(AltsProtocolNegotiator.TSI_PEER_KEY, (Object)peer).set(AltsProtocolNegotiator.AUTH_CONTEXT_KEY, authContext).set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)details.getSecurityLevel());
        localPne = InternalProtocolNegotiationEvent.withAttributes((ProtocolNegotiationEvent)localPne, (Attributes)attrs.build());
        localPne = InternalProtocolNegotiationEvent.withSecurity((ProtocolNegotiationEvent)localPne, (InternalChannelz.Security)details.getSecurity());
        ctx.fireUserEventTriggered((Object)localPne);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendHandshake(ChannelHandlerContext ctx) throws GeneralSecurityException {
        while (true) {
            ByteBuf buf;
            boolean written;
            block6: {
                int n;
                written = false;
                buf = ctx.alloc().buffer(1024).retain();
                try {
                    this.handshaker.getBytesToSendToPeer(buf);
                    if (buf.isReadable()) {
                        ctx.writeAndFlush((Object)buf).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                        written = true;
                        break block6;
                    }
                    n = written ? 1 : 2;
                }
                catch (GeneralSecurityException e) {
                    try {
                        throw new GeneralSecurityException("TsiHandshakeHandler encountered exception", e);
                    }
                    catch (Throwable throwable) {
                        buf.release(written ? 1 : 2);
                        throw throwable;
                    }
                }
                buf.release(n);
                return;
            }
            buf.release(written ? 1 : 2);
        }
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.handshaker.close();
    }

    public static abstract class HandshakeValidator {
        public abstract SecurityDetails validatePeerObject(Object var1) throws GeneralSecurityException;

        public static final class SecurityDetails {
            private final SecurityLevel securityLevel;
            private final InternalChannelz.Security security;

            public SecurityDetails(SecurityLevel securityLevel, @Nullable InternalChannelz.Security security) {
                this.securityLevel = (SecurityLevel)Preconditions.checkNotNull((Object)securityLevel, (Object)"securityLevel");
                this.security = security;
            }

            public InternalChannelz.Security getSecurity() {
                return this.security;
            }

            public SecurityLevel getSecurityLevel() {
                return this.securityLevel;
            }
        }
    }
}

