/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.util.function.LongPredicate;
import org.apache.bookkeeper.util.collections.ConcurrentLongLongHashMap;

public class EntryLogMetadata {
    private final long entryLogId;
    private long totalSize;
    private long remainingSize;
    private final ConcurrentLongLongHashMap ledgersMap;

    public EntryLogMetadata(long logId) {
        this.entryLogId = logId;
        this.remainingSize = 0L;
        this.totalSize = 0L;
        this.ledgersMap = new ConcurrentLongLongHashMap(256, 1);
    }

    public void addLedgerSize(long ledgerId, long size) {
        this.totalSize += size;
        this.remainingSize += size;
        this.ledgersMap.addAndGet(ledgerId, size);
    }

    public boolean containsLedger(long ledgerId) {
        return this.ledgersMap.containsKey(ledgerId);
    }

    public double getUsage() {
        if (this.totalSize == 0L) {
            return 0.0;
        }
        return (double)this.remainingSize / (double)this.totalSize;
    }

    public boolean isEmpty() {
        return this.ledgersMap.isEmpty();
    }

    public long getEntryLogId() {
        return this.entryLogId;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getRemainingSize() {
        return this.remainingSize;
    }

    public ConcurrentLongLongHashMap getLedgersMap() {
        return this.ledgersMap;
    }

    public void removeLedgerIf(LongPredicate predicate) {
        this.ledgersMap.removeIf((ledgerId, size) -> {
            boolean shouldRemove = predicate.test(ledgerId);
            if (shouldRemove) {
                this.remainingSize -= size;
            }
            return shouldRemove;
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ totalSize = ").append(this.totalSize).append(", remainingSize = ").append(this.remainingSize).append(", ledgersMap = ").append(this.ledgersMap).append(" }");
        return sb.toString();
    }
}

