/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.rocksdb.AbstractTraceWriter;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyMetaData;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactRangeOptions;
import org.rocksdb.CompactionJobInfo;
import org.rocksdb.CompactionOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DBOptionsInterface;
import org.rocksdb.Env;
import org.rocksdb.FlushOptions;
import org.rocksdb.Holder;
import org.rocksdb.IngestExternalFileOptions;
import org.rocksdb.LiveFileMetaData;
import org.rocksdb.LogFile;
import org.rocksdb.MutableColumnFamilyOptions;
import org.rocksdb.MutableDBOptions;
import org.rocksdb.NativeLibraryLoader;
import org.rocksdb.Options;
import org.rocksdb.Range;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksEnv;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksObject;
import org.rocksdb.SizeApproximationFlag;
import org.rocksdb.Slice;
import org.rocksdb.Snapshot;
import org.rocksdb.TableProperties;
import org.rocksdb.TraceOptions;
import org.rocksdb.TransactionLogIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchWithIndex;
import org.rocksdb.WriteOptions;
import org.rocksdb.util.Environment;

public class RocksDB
extends RocksObject {
    public static final byte[] DEFAULT_COLUMN_FAMILY = "default".getBytes();
    public static final int NOT_FOUND = -1;
    private static AtomicReference<LibraryState> libraryLoaded = new AtomicReference<LibraryState>(LibraryState.NOT_LOADED);
    protected DBOptionsInterface options_;

    public static void loadLibrary() {
        if (libraryLoaded.get() == LibraryState.LOADED) {
            return;
        }
        if (libraryLoaded.compareAndSet(LibraryState.NOT_LOADED, LibraryState.LOADING)) {
            String string = System.getenv("ROCKSDB_SHAREDLIB_DIR");
            for (CompressionType compressionType : CompressionType.values()) {
                try {
                    if (compressionType.getLibraryName() == null) continue;
                    System.loadLibrary(compressionType.getLibraryName());
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
            try {
                NativeLibraryLoader.getInstance().loadLibrary(string);
            }
            catch (IOException iOException) {
                libraryLoaded.set(LibraryState.NOT_LOADED);
                throw new RuntimeException("Unable to load the RocksDB shared library", iOException);
            }
            libraryLoaded.set(LibraryState.LOADED);
            return;
        }
        while (libraryLoaded.get() == LibraryState.LOADING) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void loadLibrary(List<String> list) {
        if (libraryLoaded.get() == LibraryState.LOADED) {
            return;
        }
        if (libraryLoaded.compareAndSet(LibraryState.NOT_LOADED, LibraryState.LOADING)) {
            block6: for (CompressionType object : CompressionType.values()) {
                if (object.equals((Object)CompressionType.NO_COMPRESSION)) continue;
                for (String string : list) {
                    try {
                        System.load(string + "/" + Environment.getSharedLibraryFileName(object.getLibraryName()));
                        continue block6;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    }
                }
            }
            boolean bl = false;
            UnsatisfiedLinkError unsatisfiedLinkError = null;
            for (String string : list) {
                try {
                    System.load(string + "/" + Environment.getJniLibraryFileName("rocksdbjni"));
                    bl = true;
                    break;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    unsatisfiedLinkError = unsatisfiedLinkError2;
                }
            }
            if (!bl) {
                libraryLoaded.set(LibraryState.NOT_LOADED);
                throw unsatisfiedLinkError;
            }
            libraryLoaded.set(LibraryState.LOADED);
            return;
        }
        while (libraryLoaded.get() == LibraryState.LOADING) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected RocksDB(long l) {
        super(l);
    }

    public static RocksDB open(String string) throws RocksDBException {
        Options options = new Options();
        options.setCreateIfMissing(true);
        return RocksDB.open(options, string);
    }

    public static RocksDB open(String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        DBOptions dBOptions = new DBOptions();
        return RocksDB.open(dBOptions, string, list, list2);
    }

    public static RocksDB open(Options options, String string) throws RocksDBException {
        RocksDB rocksDB = new RocksDB(RocksDB.open(options.nativeHandle_, string));
        rocksDB.storeOptionsInstance(options);
        return rocksDB;
    }

    public static RocksDB open(DBOptions dBOptions, String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        Object object;
        byte[][] byArrayArray = new byte[list.size()][];
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            byArrayArray[i] = ((ColumnFamilyDescriptor)object).getName();
            lArray[i] = ((ColumnFamilyDescriptor)object).getOptions().nativeHandle_;
        }
        long[] lArray2 = RocksDB.open(dBOptions.nativeHandle_, string, byArrayArray, lArray);
        object = new RocksDB(lArray2[0]);
        ((RocksDB)object).storeOptionsInstance(dBOptions);
        for (int i = 1; i < lArray2.length; ++i) {
            list2.add(new ColumnFamilyHandle((RocksDB)object, lArray2[i]));
        }
        return object;
    }

    public static RocksDB openReadOnly(String string) throws RocksDBException {
        Options options = new Options();
        return RocksDB.openReadOnly(options, string);
    }

    public static RocksDB openReadOnly(String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        DBOptions dBOptions = new DBOptions();
        return RocksDB.openReadOnly(dBOptions, string, list, list2);
    }

    public static RocksDB openReadOnly(Options options, String string) throws RocksDBException {
        RocksDB rocksDB = new RocksDB(RocksDB.openROnly(options.nativeHandle_, string));
        rocksDB.storeOptionsInstance(options);
        return rocksDB;
    }

    public static RocksDB openReadOnly(DBOptions dBOptions, String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2) throws RocksDBException {
        Object object;
        byte[][] byArrayArray = new byte[list.size()][];
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            byArrayArray[i] = ((ColumnFamilyDescriptor)object).getName();
            lArray[i] = ((ColumnFamilyDescriptor)object).getOptions().nativeHandle_;
        }
        long[] lArray2 = RocksDB.openROnly(dBOptions.nativeHandle_, string, byArrayArray, lArray);
        object = new RocksDB(lArray2[0]);
        ((RocksDB)object).storeOptionsInstance(dBOptions);
        for (int i = 1; i < lArray2.length; ++i) {
            list2.add(new ColumnFamilyHandle((RocksDB)object, lArray2[i]));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeE() throws RocksDBException {
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                RocksDB.closeDatabase(this.nativeHandle_);
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                RocksDB.closeDatabase(this.nativeHandle_);
            }
            catch (RocksDBException rocksDBException) {
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    public static List<byte[]> listColumnFamilies(Options options, String string) throws RocksDBException {
        return Arrays.asList(RocksDB.listColumnFamilies(options.nativeHandle_, string));
    }

    public ColumnFamilyHandle createColumnFamily(ColumnFamilyDescriptor columnFamilyDescriptor) throws RocksDBException {
        return new ColumnFamilyHandle(this, this.createColumnFamily(this.nativeHandle_, columnFamilyDescriptor.getName(), columnFamilyDescriptor.getName().length, columnFamilyDescriptor.getOptions().nativeHandle_));
    }

    public List<ColumnFamilyHandle> createColumnFamilies(ColumnFamilyOptions columnFamilyOptions, List<byte[]> list) throws RocksDBException {
        byte[][] byArray = (byte[][])list.toArray((T[])new byte[0][]);
        long[] lArray = this.createColumnFamilies(this.nativeHandle_, columnFamilyOptions.nativeHandle_, byArray);
        ArrayList<ColumnFamilyHandle> arrayList = new ArrayList<ColumnFamilyHandle>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            arrayList.add(new ColumnFamilyHandle(this, lArray[i]));
        }
        return arrayList;
    }

    public List<ColumnFamilyHandle> createColumnFamilies(List<ColumnFamilyDescriptor> list) throws RocksDBException {
        Object object;
        long[] lArray = new long[list.size()];
        byte[][] byArrayArray = new byte[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            lArray[i] = ((ColumnFamilyDescriptor)object).getOptions().nativeHandle_;
            byArrayArray[i] = ((ColumnFamilyDescriptor)object).getName();
        }
        long[] lArray2 = this.createColumnFamilies(this.nativeHandle_, lArray, (byte[][])byArrayArray);
        object = new ArrayList(lArray2.length);
        for (int i = 0; i < lArray2.length; ++i) {
            object.add(new ColumnFamilyHandle(this, lArray2[i]));
        }
        return object;
    }

    public void dropColumnFamily(ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        this.dropColumnFamily(this.nativeHandle_, columnFamilyHandle.nativeHandle_);
    }

    public void dropColumnFamilies(List<ColumnFamilyHandle> list) throws RocksDBException {
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        this.dropColumnFamilies(this.nativeHandle_, lArray);
    }

    public void put(byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public void put(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        RocksDB.checkBounds(n3, n4, byArray2.length);
        this.put(this.nativeHandle_, byArray, n, n2, byArray2, n3, n4);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        RocksDB.checkBounds(n3, n4, byArray2.length);
        this.put(this.nativeHandle_, byArray, n, n2, byArray2, n3, n4, columnFamilyHandle.nativeHandle_);
    }

    public void put(WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public void put(WriteOptions writeOptions, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        RocksDB.checkBounds(n3, n4, byArray2.length);
        this.put(this.nativeHandle_, writeOptions.nativeHandle_, byArray, n, n2, byArray2, n3, n4);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.put(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws RocksDBException {
        assert (byteBuffer.isDirect() && byteBuffer2.isDirect());
        this.putDirect(this.nativeHandle_, writeOptions.nativeHandle_, byteBuffer, byteBuffer.position(), byteBuffer.remaining(), byteBuffer2, byteBuffer2.position(), byteBuffer2.remaining(), columnFamilyHandle.nativeHandle_);
        byteBuffer.position(byteBuffer.limit());
        byteBuffer2.position(byteBuffer2.limit());
    }

    public void put(WriteOptions writeOptions, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws RocksDBException {
        assert (byteBuffer.isDirect() && byteBuffer2.isDirect());
        this.putDirect(this.nativeHandle_, writeOptions.nativeHandle_, byteBuffer, byteBuffer.position(), byteBuffer.remaining(), byteBuffer2, byteBuffer2.position(), byteBuffer2.remaining(), 0L);
        byteBuffer.position(byteBuffer.limit());
        byteBuffer2.position(byteBuffer2.limit());
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        RocksDB.checkBounds(n3, n4, byArray2.length);
        this.put(this.nativeHandle_, writeOptions.nativeHandle_, byArray, n, n2, byArray2, n3, n4, columnFamilyHandle.nativeHandle_);
    }

    @Deprecated
    public void remove(byte[] byArray) throws RocksDBException {
        this.delete(byArray);
    }

    public void delete(byte[] byArray) throws RocksDBException {
        this.delete(this.nativeHandle_, byArray, 0, byArray.length);
    }

    public void delete(byte[] byArray, int n, int n2) throws RocksDBException {
        this.delete(this.nativeHandle_, byArray, n, n2);
    }

    @Deprecated
    public void remove(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        this.delete(columnFamilyHandle, byArray);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        this.delete(this.nativeHandle_, byArray, 0, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, int n, int n2) throws RocksDBException {
        this.delete(this.nativeHandle_, byArray, n, n2, columnFamilyHandle.nativeHandle_);
    }

    @Deprecated
    public void remove(WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.delete(writeOptions, byArray);
    }

    public void delete(WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.delete(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length);
    }

    public void delete(WriteOptions writeOptions, byte[] byArray, int n, int n2) throws RocksDBException {
        this.delete(this.nativeHandle_, writeOptions.nativeHandle_, byArray, n, n2);
    }

    @Deprecated
    public void remove(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.delete(columnFamilyHandle, writeOptions, byArray);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.delete(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray, int n, int n2) throws RocksDBException {
        this.delete(this.nativeHandle_, writeOptions.nativeHandle_, byArray, n, n2, columnFamilyHandle.nativeHandle_);
    }

    public int get(ReadOptions readOptions, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws RocksDBException {
        assert (byteBuffer.isDirect() && byteBuffer2.isDirect());
        int n = this.getDirect(this.nativeHandle_, readOptions.nativeHandle_, byteBuffer, byteBuffer.position(), byteBuffer.remaining(), byteBuffer2, byteBuffer2.position(), byteBuffer2.remaining(), 0L);
        if (n != -1) {
            byteBuffer2.limit(Math.min(byteBuffer2.limit(), byteBuffer2.position() + n));
        }
        byteBuffer.position(byteBuffer.limit());
        return n;
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws RocksDBException {
        assert (byteBuffer.isDirect() && byteBuffer2.isDirect());
        int n = this.getDirect(this.nativeHandle_, readOptions.nativeHandle_, byteBuffer, byteBuffer.position(), byteBuffer.remaining(), byteBuffer2, byteBuffer2.position(), byteBuffer2.remaining(), columnFamilyHandle.nativeHandle_);
        if (n != -1) {
            byteBuffer2.limit(Math.min(byteBuffer2.limit(), byteBuffer2.position() + n));
        }
        byteBuffer.position(byteBuffer.limit());
        return n;
    }

    public void singleDelete(byte[] byArray) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, byArray, byArray.length);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public void singleDelete(WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, writeOptions.nativeHandle_, byArray, byArray.length);
    }

    public void singleDelete(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray) throws RocksDBException {
        this.singleDelete(this.nativeHandle_, writeOptions.nativeHandle_, byArray, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public void deleteRange(byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public void deleteRange(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void deleteRange(WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public void deleteRange(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.deleteRange(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void merge(byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.merge(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public void merge(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        RocksDB.checkBounds(n3, n4, byArray2.length);
        this.merge(this.nativeHandle_, byArray, n, n2, byArray2, n3, n4);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.merge(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        RocksDB.checkBounds(n3, n4, byArray2.length);
        this.merge(this.nativeHandle_, byArray, n, n2, byArray2, n3, n4, columnFamilyHandle.nativeHandle_);
    }

    public void merge(WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.merge(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public void merge(WriteOptions writeOptions, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        RocksDB.checkBounds(n3, n4, byArray2.length);
        this.merge(this.nativeHandle_, writeOptions.nativeHandle_, byArray, n, n2, byArray2, n3, n4);
    }

    public void delete(WriteOptions writeOptions, ByteBuffer byteBuffer) throws RocksDBException {
        assert (byteBuffer.isDirect());
        this.deleteDirect(this.nativeHandle_, writeOptions.nativeHandle_, byteBuffer, byteBuffer.position(), byteBuffer.remaining(), 0L);
        byteBuffer.position(byteBuffer.limit());
    }

    public void delete(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, ByteBuffer byteBuffer) throws RocksDBException {
        assert (byteBuffer.isDirect());
        this.deleteDirect(this.nativeHandle_, writeOptions.nativeHandle_, byteBuffer, byteBuffer.position(), byteBuffer.remaining(), columnFamilyHandle.nativeHandle_);
        byteBuffer.position(byteBuffer.limit());
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.merge(this.nativeHandle_, writeOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public void merge(ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        RocksDB.checkBounds(n3, n4, byArray2.length);
        this.merge(this.nativeHandle_, writeOptions.nativeHandle_, byArray, n, n2, byArray2, n3, n4, columnFamilyHandle.nativeHandle_);
    }

    public void write(WriteOptions writeOptions, WriteBatch writeBatch) throws RocksDBException {
        this.write0(this.nativeHandle_, writeOptions.nativeHandle_, writeBatch.nativeHandle_);
    }

    public void write(WriteOptions writeOptions, WriteBatchWithIndex writeBatchWithIndex) throws RocksDBException {
        this.write1(this.nativeHandle_, writeOptions.nativeHandle_, writeBatchWithIndex.nativeHandle_);
    }

    public int get(byte[] byArray, byte[] byArray2) throws RocksDBException {
        return this.get(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public int get(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        RocksDB.checkBounds(n3, n4, byArray2.length);
        return this.get(this.nativeHandle_, byArray, n, n2, byArray2, n3, n4);
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException, IllegalArgumentException {
        return this.get(this.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws RocksDBException, IllegalArgumentException {
        RocksDB.checkBounds(n, n2, byArray.length);
        RocksDB.checkBounds(n3, n4, byArray2.length);
        return this.get(this.nativeHandle_, byArray, n, n2, byArray2, n3, n4, columnFamilyHandle.nativeHandle_);
    }

    public int get(ReadOptions readOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public int get(ReadOptions readOptions, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        RocksDB.checkBounds(n3, n4, byArray2.length);
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, n, n2, byArray2, n3, n4);
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] byArray, byte[] byArray2) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, 0, byArray.length, byArray2, 0, byArray2.length, columnFamilyHandle.nativeHandle_);
    }

    public int get(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        RocksDB.checkBounds(n3, n4, byArray2.length);
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, n, n2, byArray2, n3, n4, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, byArray, 0, byArray.length);
    }

    public byte[] get(byte[] byArray, int n, int n2) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        return this.get(this.nativeHandle_, byArray, n, n2);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, byArray, 0, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, int n, int n2) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        return this.get(this.nativeHandle_, byArray, n, n2, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(ReadOptions readOptions, byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, 0, byArray.length);
    }

    public byte[] get(ReadOptions readOptions, byte[] byArray, int n, int n2) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, n, n2);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] byArray) throws RocksDBException {
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, 0, byArray.length, columnFamilyHandle.nativeHandle_);
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] byArray, int n, int n2) throws RocksDBException {
        RocksDB.checkBounds(n, n2, byArray.length);
        return this.get(this.nativeHandle_, readOptions.nativeHandle_, byArray, n, n2, columnFamilyHandle.nativeHandle_);
    }

    @Deprecated
    public Map<byte[], byte[]> multiGet(List<byte[]> list) throws RocksDBException {
        assert (list.size() != 0);
        byte[][] byArray = (byte[][])list.toArray((T[])new byte[0][]);
        int[] nArray = new int[byArray.length];
        int[] nArray2 = new int[byArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = byArray[i].length;
        }
        byte[][] byArray2 = this.multiGet(this.nativeHandle_, byArray, nArray, nArray2);
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>(RocksDB.computeCapacityHint(byArray2.length));
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == null) continue;
            hashMap.put(list.get(i), byArray2[i]);
        }
        return hashMap;
    }

    @Deprecated
    public Map<byte[], byte[]> multiGet(List<ColumnFamilyHandle> list, List<byte[]> list2) throws RocksDBException, IllegalArgumentException {
        assert (list2.size() != 0);
        if (list2.size() != list.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        byte[][] byArray = (byte[][])list2.toArray((T[])new byte[0][]);
        int[] nArray = new int[byArray.length];
        int[] nArray2 = new int[byArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = byArray[i].length;
        }
        byte[][] byArray2 = this.multiGet(this.nativeHandle_, byArray, nArray, nArray2, lArray);
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>(RocksDB.computeCapacityHint(byArray2.length));
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == null) continue;
            hashMap.put(list2.get(i), byArray2[i]);
        }
        return hashMap;
    }

    @Deprecated
    public Map<byte[], byte[]> multiGet(ReadOptions readOptions, List<byte[]> list) throws RocksDBException {
        assert (list.size() != 0);
        byte[][] byArray = (byte[][])list.toArray((T[])new byte[0][]);
        int[] nArray = new int[byArray.length];
        int[] nArray2 = new int[byArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = byArray[i].length;
        }
        byte[][] byArray2 = this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, byArray, nArray, nArray2);
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>(RocksDB.computeCapacityHint(byArray2.length));
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == null) continue;
            hashMap.put(list.get(i), byArray2[i]);
        }
        return hashMap;
    }

    @Deprecated
    public Map<byte[], byte[]> multiGet(ReadOptions readOptions, List<ColumnFamilyHandle> list, List<byte[]> list2) throws RocksDBException {
        assert (list2.size() != 0);
        if (list2.size() != list.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        byte[][] byArray = (byte[][])list2.toArray((T[])new byte[0][]);
        int[] nArray = new int[byArray.length];
        int[] nArray2 = new int[byArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = byArray[i].length;
        }
        byte[][] byArray2 = this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, byArray, nArray, nArray2, lArray);
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>(RocksDB.computeCapacityHint(byArray2.length));
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == null) continue;
            hashMap.put(list2.get(i), byArray2[i]);
        }
        return hashMap;
    }

    public List<byte[]> multiGetAsList(List<byte[]> list) throws RocksDBException {
        assert (list.size() != 0);
        byte[][] byArray = (byte[][])list.toArray((T[])new byte[list.size()][]);
        int[] nArray = new int[byArray.length];
        int[] nArray2 = new int[byArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = byArray[i].length;
        }
        return Arrays.asList(this.multiGet(this.nativeHandle_, byArray, nArray, nArray2));
    }

    public List<byte[]> multiGetAsList(List<ColumnFamilyHandle> list, List<byte[]> list2) throws RocksDBException, IllegalArgumentException {
        assert (list2.size() != 0);
        if (list2.size() != list.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        byte[][] byArray = (byte[][])list2.toArray((T[])new byte[list2.size()][]);
        int[] nArray = new int[byArray.length];
        int[] nArray2 = new int[byArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = byArray[i].length;
        }
        return Arrays.asList(this.multiGet(this.nativeHandle_, byArray, nArray, nArray2, lArray));
    }

    public List<byte[]> multiGetAsList(ReadOptions readOptions, List<byte[]> list) throws RocksDBException {
        assert (list.size() != 0);
        byte[][] byArray = (byte[][])list.toArray((T[])new byte[list.size()][]);
        int[] nArray = new int[byArray.length];
        int[] nArray2 = new int[byArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = byArray[i].length;
        }
        return Arrays.asList(this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, byArray, nArray, nArray2));
    }

    public List<byte[]> multiGetAsList(ReadOptions readOptions, List<ColumnFamilyHandle> list, List<byte[]> list2) throws RocksDBException {
        assert (list2.size() != 0);
        if (list2.size() != list.size()) {
            throw new IllegalArgumentException("For each key there must be a ColumnFamilyHandle.");
        }
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        byte[][] byArray = (byte[][])list2.toArray((T[])new byte[list2.size()][]);
        int[] nArray = new int[byArray.length];
        int[] nArray2 = new int[byArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = byArray[i].length;
        }
        return Arrays.asList(this.multiGet(this.nativeHandle_, readOptions.nativeHandle_, byArray, nArray, nArray2, lArray));
    }

    public boolean keyMayExist(byte[] byArray, Holder<byte[]> holder) {
        return this.keyMayExist(byArray, 0, byArray.length, holder);
    }

    public boolean keyMayExist(byte[] byArray, int n, int n2, Holder<byte[]> holder) {
        return this.keyMayExist((ColumnFamilyHandle)null, byArray, n, n2, holder);
    }

    public boolean keyMayExist(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, Holder<byte[]> holder) {
        return this.keyMayExist(columnFamilyHandle, byArray, 0, byArray.length, holder);
    }

    public boolean keyMayExist(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, int n, int n2, Holder<byte[]> holder) {
        return this.keyMayExist(columnFamilyHandle, null, byArray, n, n2, holder);
    }

    public boolean keyMayExist(ReadOptions readOptions, byte[] byArray, Holder<byte[]> holder) {
        return this.keyMayExist(readOptions, byArray, 0, byArray.length, holder);
    }

    public boolean keyMayExist(ReadOptions readOptions, byte[] byArray, int n, int n2, Holder<byte[]> holder) {
        return this.keyMayExist(null, readOptions, byArray, n, n2, holder);
    }

    public boolean keyMayExist(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] byArray, Holder<byte[]> holder) {
        return this.keyMayExist(columnFamilyHandle, readOptions, byArray, 0, byArray.length, holder);
    }

    public boolean keyMayExist(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions, byte[] byArray, int n, int n2, Holder<byte[]> holder) {
        RocksDB.checkBounds(n, n2, byArray.length);
        if (holder == null) {
            return this.keyMayExist(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, readOptions == null ? 0L : readOptions.nativeHandle_, byArray, n, n2);
        }
        byte[][] byArray2 = this.keyMayExistFoundValue(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, readOptions == null ? 0L : readOptions.nativeHandle_, byArray, n, n2);
        if (byArray2[0][0] == 0) {
            holder.setValue(null);
            return false;
        }
        if (byArray2[0][0] == 1) {
            holder.setValue(null);
            return true;
        }
        holder.setValue(byArray2[1]);
        return true;
    }

    public RocksIterator newIterator() {
        return new RocksIterator(this, this.iterator(this.nativeHandle_));
    }

    public RocksIterator newIterator(ReadOptions readOptions) {
        return new RocksIterator(this, this.iterator(this.nativeHandle_, readOptions.nativeHandle_));
    }

    public RocksIterator newIterator(ColumnFamilyHandle columnFamilyHandle) {
        return new RocksIterator(this, this.iteratorCF(this.nativeHandle_, columnFamilyHandle.nativeHandle_));
    }

    public RocksIterator newIterator(ColumnFamilyHandle columnFamilyHandle, ReadOptions readOptions) {
        return new RocksIterator(this, this.iteratorCF(this.nativeHandle_, columnFamilyHandle.nativeHandle_, readOptions.nativeHandle_));
    }

    public List<RocksIterator> newIterators(List<ColumnFamilyHandle> list) throws RocksDBException {
        return this.newIterators(list, new ReadOptions());
    }

    public List<RocksIterator> newIterators(List<ColumnFamilyHandle> list, ReadOptions readOptions) throws RocksDBException {
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        long[] lArray2 = this.iterators(this.nativeHandle_, lArray, readOptions.nativeHandle_);
        ArrayList<RocksIterator> arrayList = new ArrayList<RocksIterator>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new RocksIterator(this, lArray2[i]));
        }
        return arrayList;
    }

    public Snapshot getSnapshot() {
        long l = this.getSnapshot(this.nativeHandle_);
        if (l != 0L) {
            return new Snapshot(l);
        }
        return null;
    }

    public void releaseSnapshot(Snapshot snapshot) {
        if (snapshot != null) {
            this.releaseSnapshot(this.nativeHandle_, snapshot.nativeHandle_);
        }
    }

    public String getProperty(ColumnFamilyHandle columnFamilyHandle, String string) throws RocksDBException {
        return this.getProperty(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, string, string.length());
    }

    public String getProperty(String string) throws RocksDBException {
        return this.getProperty(null, string);
    }

    public Map<String, String> getMapProperty(String string) throws RocksDBException {
        return this.getMapProperty(null, string);
    }

    public Map<String, String> getMapProperty(ColumnFamilyHandle columnFamilyHandle, String string) throws RocksDBException {
        return this.getMapProperty(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, string, string.length());
    }

    public long getLongProperty(String string) throws RocksDBException {
        return this.getLongProperty(null, string);
    }

    public long getLongProperty(ColumnFamilyHandle columnFamilyHandle, String string) throws RocksDBException {
        return this.getLongProperty(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, string, string.length());
    }

    public void resetStats() throws RocksDBException {
        this.resetStats(this.nativeHandle_);
    }

    public long getAggregatedLongProperty(String string) throws RocksDBException {
        return this.getAggregatedLongProperty(this.nativeHandle_, string, string.length());
    }

    public long[] getApproximateSizes(ColumnFamilyHandle columnFamilyHandle, List<Range> list, SizeApproximationFlag ... sizeApproximationFlagArray) {
        byte by = 0;
        for (SizeApproximationFlag sizeApproximationFlag : sizeApproximationFlagArray) {
            by = (byte)(by | sizeApproximationFlag.getValue());
        }
        return this.getApproximateSizes(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, RocksDB.toRangeSliceHandles(list), by);
    }

    public long[] getApproximateSizes(List<Range> list, SizeApproximationFlag ... sizeApproximationFlagArray) {
        return this.getApproximateSizes(null, list, sizeApproximationFlagArray);
    }

    public CountAndSize getApproximateMemTableStats(ColumnFamilyHandle columnFamilyHandle, Range range) {
        long[] lArray = this.getApproximateMemTableStats(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, range.start.getNativeHandle(), range.limit.getNativeHandle());
        return new CountAndSize(lArray[0], lArray[1]);
    }

    public CountAndSize getApproximateMemTableStats(Range range) {
        return this.getApproximateMemTableStats(null, range);
    }

    public void compactRange() throws RocksDBException {
        this.compactRange(null);
    }

    public void compactRange(ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        this.compactRange(this.nativeHandle_, null, -1, null, -1, 0L, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public void compactRange(byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.compactRange(null, byArray, byArray2);
    }

    public void compactRange(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2) throws RocksDBException {
        this.compactRange(this.nativeHandle_, byArray, byArray == null ? -1 : byArray.length, byArray2, byArray2 == null ? -1 : byArray2.length, 0L, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    @Deprecated
    public void compactRange(boolean bl, int n, int n2) throws RocksDBException {
        this.compactRange(null, bl, n, n2);
    }

    @Deprecated
    public void compactRange(ColumnFamilyHandle columnFamilyHandle, boolean bl, int n, int n2) throws RocksDBException {
        CompactRangeOptions compactRangeOptions = new CompactRangeOptions();
        compactRangeOptions.setChangeLevel(bl);
        compactRangeOptions.setTargetLevel(n);
        compactRangeOptions.setTargetPathId(n2);
        this.compactRange(this.nativeHandle_, null, -1, null, -1, compactRangeOptions.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    @Deprecated
    public void compactRange(byte[] byArray, byte[] byArray2, boolean bl, int n, int n2) throws RocksDBException {
        this.compactRange(null, byArray, byArray2, bl, n, n2);
    }

    @Deprecated
    public void compactRange(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2, boolean bl, int n, int n2) throws RocksDBException {
        CompactRangeOptions compactRangeOptions = new CompactRangeOptions();
        compactRangeOptions.setChangeLevel(bl);
        compactRangeOptions.setTargetLevel(n);
        compactRangeOptions.setTargetPathId(n2);
        this.compactRange(this.nativeHandle_, byArray, byArray == null ? -1 : byArray.length, byArray2, byArray2 == null ? -1 : byArray2.length, compactRangeOptions.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public void compactRange(ColumnFamilyHandle columnFamilyHandle, byte[] byArray, byte[] byArray2, CompactRangeOptions compactRangeOptions) throws RocksDBException {
        this.compactRange(this.nativeHandle_, byArray, byArray == null ? -1 : byArray.length, byArray2, byArray2 == null ? -1 : byArray2.length, compactRangeOptions.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public void setOptions(ColumnFamilyHandle columnFamilyHandle, MutableColumnFamilyOptions mutableColumnFamilyOptions) throws RocksDBException {
        this.setOptions(this.nativeHandle_, columnFamilyHandle.nativeHandle_, mutableColumnFamilyOptions.getKeys(), mutableColumnFamilyOptions.getValues());
    }

    public void setOptions(MutableColumnFamilyOptions mutableColumnFamilyOptions) throws RocksDBException {
        this.setOptions(null, mutableColumnFamilyOptions);
    }

    public void setDBOptions(MutableDBOptions mutableDBOptions) throws RocksDBException {
        this.setDBOptions(this.nativeHandle_, mutableDBOptions.getKeys(), mutableDBOptions.getValues());
    }

    public List<String> compactFiles(CompactionOptions compactionOptions, List<String> list, int n, int n2, CompactionJobInfo compactionJobInfo) throws RocksDBException {
        return this.compactFiles(compactionOptions, null, list, n, n2, compactionJobInfo);
    }

    public List<String> compactFiles(CompactionOptions compactionOptions, ColumnFamilyHandle columnFamilyHandle, List<String> list, int n, int n2, CompactionJobInfo compactionJobInfo) throws RocksDBException {
        return Arrays.asList(this.compactFiles(this.nativeHandle_, compactionOptions.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, list.toArray(new String[0]), n, n2, compactionJobInfo == null ? 0L : compactionJobInfo.nativeHandle_));
    }

    public void cancelAllBackgroundWork(boolean bl) {
        this.cancelAllBackgroundWork(this.nativeHandle_, bl);
    }

    public void pauseBackgroundWork() throws RocksDBException {
        this.pauseBackgroundWork(this.nativeHandle_);
    }

    public void continueBackgroundWork() throws RocksDBException {
        this.continueBackgroundWork(this.nativeHandle_);
    }

    public void enableAutoCompaction(List<ColumnFamilyHandle> list) throws RocksDBException {
        this.enableAutoCompaction(this.nativeHandle_, this.toNativeHandleList(list));
    }

    public int numberLevels() {
        return this.numberLevels(null);
    }

    public int numberLevels(ColumnFamilyHandle columnFamilyHandle) {
        return this.numberLevels(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public int maxMemCompactionLevel() {
        return this.maxMemCompactionLevel(null);
    }

    public int maxMemCompactionLevel(ColumnFamilyHandle columnFamilyHandle) {
        return this.maxMemCompactionLevel(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public int level0StopWriteTrigger() {
        return this.level0StopWriteTrigger(null);
    }

    public int level0StopWriteTrigger(ColumnFamilyHandle columnFamilyHandle) {
        return this.level0StopWriteTrigger(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public String getName() {
        return this.getName(this.nativeHandle_);
    }

    public Env getEnv() {
        long l = this.getEnv(this.nativeHandle_);
        if (l == Env.getDefault().nativeHandle_) {
            return Env.getDefault();
        }
        RocksEnv rocksEnv = new RocksEnv(l);
        rocksEnv.disOwnNativeHandle();
        return rocksEnv;
    }

    public void flush(FlushOptions flushOptions) throws RocksDBException {
        this.flush(flushOptions, (List<ColumnFamilyHandle>)null);
    }

    public void flush(FlushOptions flushOptions, ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        this.flush(flushOptions, columnFamilyHandle == null ? null : Arrays.asList(columnFamilyHandle));
    }

    public void flush(FlushOptions flushOptions, List<ColumnFamilyHandle> list) throws RocksDBException {
        this.flush(this.nativeHandle_, flushOptions.nativeHandle_, this.toNativeHandleList(list));
    }

    public void flushWal(boolean bl) throws RocksDBException {
        this.flushWal(this.nativeHandle_, bl);
    }

    public void syncWal() throws RocksDBException {
        this.syncWal(this.nativeHandle_);
    }

    public long getLatestSequenceNumber() {
        return this.getLatestSequenceNumber(this.nativeHandle_);
    }

    public boolean setPreserveDeletesSequenceNumber(long l) {
        return this.setPreserveDeletesSequenceNumber(this.nativeHandle_, l);
    }

    public void disableFileDeletions() throws RocksDBException {
        this.disableFileDeletions(this.nativeHandle_);
    }

    public void enableFileDeletions(boolean bl) throws RocksDBException {
        this.enableFileDeletions(this.nativeHandle_, bl);
    }

    public LiveFiles getLiveFiles() throws RocksDBException {
        return this.getLiveFiles(true);
    }

    public LiveFiles getLiveFiles(boolean bl) throws RocksDBException {
        String[] stringArray = this.getLiveFiles(this.nativeHandle_, bl);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length - 1);
        long l = Long.parseLong(stringArray[stringArray.length - 1]);
        return new LiveFiles(l, Arrays.asList(stringArray2));
    }

    public List<LogFile> getSortedWalFiles() throws RocksDBException {
        LogFile[] logFileArray = this.getSortedWalFiles(this.nativeHandle_);
        return Arrays.asList(logFileArray);
    }

    public TransactionLogIterator getUpdatesSince(long l) throws RocksDBException {
        return new TransactionLogIterator(this.getUpdatesSince(this.nativeHandle_, l));
    }

    public void deleteFile(String string) throws RocksDBException {
        this.deleteFile(this.nativeHandle_, string);
    }

    public List<LiveFileMetaData> getLiveFilesMetaData() {
        return Arrays.asList(this.getLiveFilesMetaData(this.nativeHandle_));
    }

    public ColumnFamilyMetaData getColumnFamilyMetaData(ColumnFamilyHandle columnFamilyHandle) {
        return this.getColumnFamilyMetaData(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public ColumnFamilyMetaData GetColumnFamilyMetaData() {
        return this.getColumnFamilyMetaData(null);
    }

    public void ingestExternalFile(List<String> list, IngestExternalFileOptions ingestExternalFileOptions) throws RocksDBException {
        this.ingestExternalFile(this.nativeHandle_, this.getDefaultColumnFamily().nativeHandle_, list.toArray(new String[0]), list.size(), ingestExternalFileOptions.nativeHandle_);
    }

    public void ingestExternalFile(ColumnFamilyHandle columnFamilyHandle, List<String> list, IngestExternalFileOptions ingestExternalFileOptions) throws RocksDBException {
        this.ingestExternalFile(this.nativeHandle_, columnFamilyHandle.nativeHandle_, list.toArray(new String[0]), list.size(), ingestExternalFileOptions.nativeHandle_);
    }

    public void verifyChecksum() throws RocksDBException {
        this.verifyChecksum(this.nativeHandle_);
    }

    public ColumnFamilyHandle getDefaultColumnFamily() {
        ColumnFamilyHandle columnFamilyHandle = new ColumnFamilyHandle(this, this.getDefaultColumnFamily(this.nativeHandle_));
        columnFamilyHandle.disOwnNativeHandle();
        return columnFamilyHandle;
    }

    public Map<String, TableProperties> getPropertiesOfAllTables(ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        return this.getPropertiesOfAllTables(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
    }

    public Map<String, TableProperties> getPropertiesOfAllTables() throws RocksDBException {
        return this.getPropertiesOfAllTables(null);
    }

    public Map<String, TableProperties> getPropertiesOfTablesInRange(ColumnFamilyHandle columnFamilyHandle, List<Range> list) throws RocksDBException {
        return this.getPropertiesOfTablesInRange(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, RocksDB.toRangeSliceHandles(list));
    }

    public Map<String, TableProperties> getPropertiesOfTablesInRange(List<Range> list) throws RocksDBException {
        return this.getPropertiesOfTablesInRange(null, list);
    }

    public Range suggestCompactRange(ColumnFamilyHandle columnFamilyHandle) throws RocksDBException {
        long[] lArray = this.suggestCompactRange(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_);
        return new Range(new Slice(lArray[0]), new Slice(lArray[1]));
    }

    public Range suggestCompactRange() throws RocksDBException {
        return this.suggestCompactRange(null);
    }

    public void promoteL0(ColumnFamilyHandle columnFamilyHandle, int n) throws RocksDBException {
        this.promoteL0(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, n);
    }

    public void promoteL0(int n) throws RocksDBException {
        this.promoteL0(null, n);
    }

    public void startTrace(TraceOptions traceOptions, AbstractTraceWriter abstractTraceWriter) throws RocksDBException {
        this.startTrace(this.nativeHandle_, traceOptions.getMaxTraceFileSize(), abstractTraceWriter.nativeHandle_);
        abstractTraceWriter.disOwnNativeHandle();
    }

    public void endTrace() throws RocksDBException {
        this.endTrace(this.nativeHandle_);
    }

    public void deleteFilesInRanges(ColumnFamilyHandle columnFamilyHandle, List<byte[]> list, boolean bl) throws RocksDBException {
        if (list.size() == 0) {
            return;
        }
        if (list.size() % 2 != 0) {
            throw new IllegalArgumentException("Ranges size needs to be multiple of 2 (from1, to1, from2, to2, ...), but is " + list.size());
        }
        byte[][] byArray = (byte[][])list.toArray((T[])new byte[list.size()][]);
        this.deleteFilesInRanges(this.nativeHandle_, columnFamilyHandle == null ? 0L : columnFamilyHandle.nativeHandle_, byArray, bl);
    }

    public static void destroyDB(String string, Options options) throws RocksDBException {
        RocksDB.destroyDB(string, options.nativeHandle_);
    }

    private long[] toNativeHandleList(List<? extends RocksObject> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = list.get((int)i).nativeHandle_;
        }
        return lArray;
    }

    private static long[] toRangeSliceHandles(List<Range> list) {
        long[] lArray = new long[list.size() * 2];
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            Range range = list.get(i);
            lArray[n++] = range.start.getNativeHandle();
            lArray[n++] = range.limit.getNativeHandle();
        }
        return lArray;
    }

    protected void storeOptionsInstance(DBOptionsInterface dBOptionsInterface) {
        this.options_ = dBOptionsInterface;
    }

    private static void checkBounds(int n, int n2, int n3) {
        if ((n | n2 | n + n2 | n3 - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException(String.format("offset(%d), len(%d), size(%d)", n, n2, n3));
        }
    }

    private static int computeCapacityHint(int n) {
        return (int)Math.ceil((double)n * 1.5 + 1.0);
    }

    private static native long open(long var0, String var2) throws RocksDBException;

    private static native long[] open(long var0, String var2, byte[][] var3, long[] var4) throws RocksDBException;

    private static native long openROnly(long var0, String var2) throws RocksDBException;

    private static native long[] openROnly(long var0, String var2, byte[][] var3, long[] var4) throws RocksDBException;

    @Override
    protected native void disposeInternal(long var1);

    private static native void closeDatabase(long var0) throws RocksDBException;

    private static native byte[][] listColumnFamilies(long var0, String var2) throws RocksDBException;

    private native long createColumnFamily(long var1, byte[] var3, int var4, long var5) throws RocksDBException;

    private native long[] createColumnFamilies(long var1, long var3, byte[][] var5) throws RocksDBException;

    private native long[] createColumnFamilies(long var1, long[] var3, byte[][] var4) throws RocksDBException;

    private native void dropColumnFamily(long var1, long var3) throws RocksDBException;

    private native void dropColumnFamilies(long var1, long[] var3) throws RocksDBException;

    private native void put(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws RocksDBException;

    private native void put(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, long var9) throws RocksDBException;

    private native void put(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10) throws RocksDBException;

    private native void put(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10, long var11) throws RocksDBException;

    private native void delete(long var1, byte[] var3, int var4, int var5) throws RocksDBException;

    private native void delete(long var1, byte[] var3, int var4, int var5, long var6) throws RocksDBException;

    private native void delete(long var1, long var3, byte[] var5, int var6, int var7) throws RocksDBException;

    private native void delete(long var1, long var3, byte[] var5, int var6, int var7, long var8) throws RocksDBException;

    private native void singleDelete(long var1, byte[] var3, int var4) throws RocksDBException;

    private native void singleDelete(long var1, byte[] var3, int var4, long var5) throws RocksDBException;

    private native void singleDelete(long var1, long var3, byte[] var5, int var6) throws RocksDBException;

    private native void singleDelete(long var1, long var3, byte[] var5, int var6, long var7) throws RocksDBException;

    private native void deleteRange(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws RocksDBException;

    private native void deleteRange(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, long var9) throws RocksDBException;

    private native void deleteRange(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10) throws RocksDBException;

    private native void deleteRange(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10, long var11) throws RocksDBException;

    private native void merge(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws RocksDBException;

    private native void merge(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, long var9) throws RocksDBException;

    private native void merge(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10) throws RocksDBException;

    private native void merge(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10, long var11) throws RocksDBException;

    private native void write0(long var1, long var3, long var5) throws RocksDBException;

    private native void write1(long var1, long var3, long var5) throws RocksDBException;

    private native int get(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws RocksDBException;

    private native int get(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, long var9) throws RocksDBException;

    private native int get(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10) throws RocksDBException;

    private native int get(long var1, long var3, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10, long var11) throws RocksDBException;

    private native byte[] get(long var1, byte[] var3, int var4, int var5) throws RocksDBException;

    private native byte[] get(long var1, byte[] var3, int var4, int var5, long var6) throws RocksDBException;

    private native byte[] get(long var1, long var3, byte[] var5, int var6, int var7) throws RocksDBException;

    private native byte[] get(long var1, long var3, byte[] var5, int var6, int var7, long var8) throws RocksDBException;

    private native byte[][] multiGet(long var1, byte[][] var3, int[] var4, int[] var5);

    private native byte[][] multiGet(long var1, byte[][] var3, int[] var4, int[] var5, long[] var6);

    private native byte[][] multiGet(long var1, long var3, byte[][] var5, int[] var6, int[] var7);

    private native byte[][] multiGet(long var1, long var3, byte[][] var5, int[] var6, int[] var7, long[] var8);

    private native boolean keyMayExist(long var1, long var3, long var5, byte[] var7, int var8, int var9);

    private native byte[][] keyMayExistFoundValue(long var1, long var3, long var5, byte[] var7, int var8, int var9);

    private native void putDirect(long var1, long var3, ByteBuffer var5, int var6, int var7, ByteBuffer var8, int var9, int var10, long var11) throws RocksDBException;

    private native long iterator(long var1);

    private native long iterator(long var1, long var3);

    private native long iteratorCF(long var1, long var3);

    private native long iteratorCF(long var1, long var3, long var5);

    private native long[] iterators(long var1, long[] var3, long var4) throws RocksDBException;

    private native long getSnapshot(long var1);

    private native void releaseSnapshot(long var1, long var3);

    private native String getProperty(long var1, long var3, String var5, int var6) throws RocksDBException;

    private native Map<String, String> getMapProperty(long var1, long var3, String var5, int var6) throws RocksDBException;

    private native int getDirect(long var1, long var3, ByteBuffer var5, int var6, int var7, ByteBuffer var8, int var9, int var10, long var11) throws RocksDBException;

    private native void deleteDirect(long var1, long var3, ByteBuffer var5, int var6, int var7, long var8) throws RocksDBException;

    private native long getLongProperty(long var1, long var3, String var5, int var6) throws RocksDBException;

    private native void resetStats(long var1) throws RocksDBException;

    private native long getAggregatedLongProperty(long var1, String var3, int var4) throws RocksDBException;

    private native long[] getApproximateSizes(long var1, long var3, long[] var5, byte var6);

    private final native long[] getApproximateMemTableStats(long var1, long var3, long var5, long var7);

    private native void compactRange(long var1, byte[] var3, int var4, byte[] var5, int var6, long var7, long var9) throws RocksDBException;

    private native void setOptions(long var1, long var3, String[] var5, String[] var6) throws RocksDBException;

    private native void setDBOptions(long var1, String[] var3, String[] var4) throws RocksDBException;

    private native String[] compactFiles(long var1, long var3, long var5, String[] var7, int var8, int var9, long var10) throws RocksDBException;

    private native void cancelAllBackgroundWork(long var1, boolean var3);

    private native void pauseBackgroundWork(long var1) throws RocksDBException;

    private native void continueBackgroundWork(long var1) throws RocksDBException;

    private native void enableAutoCompaction(long var1, long[] var3) throws RocksDBException;

    private native int numberLevels(long var1, long var3);

    private native int maxMemCompactionLevel(long var1, long var3);

    private native int level0StopWriteTrigger(long var1, long var3);

    private native String getName(long var1);

    private native long getEnv(long var1);

    private native void flush(long var1, long var3, long[] var5) throws RocksDBException;

    private native void flushWal(long var1, boolean var3) throws RocksDBException;

    private native void syncWal(long var1) throws RocksDBException;

    private native long getLatestSequenceNumber(long var1);

    private native boolean setPreserveDeletesSequenceNumber(long var1, long var3);

    private native void disableFileDeletions(long var1) throws RocksDBException;

    private native void enableFileDeletions(long var1, boolean var3) throws RocksDBException;

    private native String[] getLiveFiles(long var1, boolean var3) throws RocksDBException;

    private native LogFile[] getSortedWalFiles(long var1) throws RocksDBException;

    private native long getUpdatesSince(long var1, long var3) throws RocksDBException;

    private native void deleteFile(long var1, String var3) throws RocksDBException;

    private native LiveFileMetaData[] getLiveFilesMetaData(long var1);

    private native ColumnFamilyMetaData getColumnFamilyMetaData(long var1, long var3);

    private native void ingestExternalFile(long var1, long var3, String[] var5, int var6, long var7) throws RocksDBException;

    private native void verifyChecksum(long var1) throws RocksDBException;

    private native long getDefaultColumnFamily(long var1);

    private native Map<String, TableProperties> getPropertiesOfAllTables(long var1, long var3) throws RocksDBException;

    private native Map<String, TableProperties> getPropertiesOfTablesInRange(long var1, long var3, long[] var5);

    private native long[] suggestCompactRange(long var1, long var3) throws RocksDBException;

    private native void promoteL0(long var1, long var3, int var5) throws RocksDBException;

    private native void startTrace(long var1, long var3, long var5) throws RocksDBException;

    private native void endTrace(long var1) throws RocksDBException;

    private native void deleteFilesInRanges(long var1, long var3, byte[][] var5, boolean var6) throws RocksDBException;

    private static native void destroyDB(String var0, long var1) throws RocksDBException;

    static {
        RocksDB.loadLibrary();
    }

    public static class LiveFiles {
        public final long manifestFileSize;
        public final List<String> files;

        LiveFiles(long l, List<String> list) {
            this.manifestFileSize = l;
            this.files = list;
        }
    }

    public static class CountAndSize {
        public final long count;
        public final long size;

        public CountAndSize(long l, long l2) {
            this.count = l;
            this.size = l2;
        }
    }

    private static enum LibraryState {
        NOT_LOADED,
        LOADING,
        LOADED;

    }
}

