/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.model;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.source.QualifiedName;
import org.inferred.freebuilder.processor.source.Shading;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

public class ModelUtils {
    private static final SimpleElementVisitor8<Optional<TypeElement>, ?> TYPE_ELEMENT_VISITOR = new SimpleElementVisitor8<Optional<TypeElement>, Void>(){

        @Override
        public Optional<TypeElement> visitType(TypeElement e, Void p) {
            return Optional.of(e);
        }

        @Override
        protected Optional<TypeElement> defaultAction(Element e, Void p) {
            return Optional.empty();
        }
    };
    private static final SimpleTypeVisitor8<Optional<DeclaredType>, ?> DECLARED_TYPE_VISITOR = new SimpleTypeVisitor8<Optional<DeclaredType>, Void>(){

        @Override
        public Optional<DeclaredType> visitDeclared(DeclaredType t, Void p) {
            return Optional.of(t);
        }

        @Override
        protected Optional<DeclaredType> defaultAction(TypeMirror e, Void p) {
            return Optional.empty();
        }
    };
    private static final SimpleTypeVisitor8<Optional<TypeVariable>, ?> TYPE_VARIABLE_VISITOR = new SimpleTypeVisitor8<Optional<TypeVariable>, Void>(){

        @Override
        public Optional<TypeVariable> visitTypeVariable(TypeVariable t, Void p) {
            return Optional.of(t);
        }

        @Override
        protected Optional<TypeVariable> defaultAction(TypeMirror e, Void p) {
            return Optional.empty();
        }
    };

    public static Optional<AnnotationMirror> findAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        return ModelUtils.findAnnotationMirror(element, Shading.unshadedName(annotationClass.getName()));
    }

    public static Optional<AnnotationMirror> findAnnotationMirror(Element element, QualifiedName annotationClass) {
        return ModelUtils.findAnnotationMirror(element, Shading.unshadedName(annotationClass.toString()));
    }

    public static Optional<AnnotationMirror> findAnnotationMirror(Element element, String annotationClassName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationTypeElement.getQualifiedName().contentEquals(annotationClassName)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }

    public static Optional<AnnotationValue> findProperty(AnnotationMirror annotation, String propertyName) {
        return annotation.getElementValues().entrySet().stream().filter(element -> ((ExecutableElement)element.getKey()).getSimpleName().contentEquals(propertyName)).findAny().map(Map.Entry::getValue);
    }

    public static Optional<TypeElement> maybeType(Element element) {
        return (Optional)TYPE_ELEMENT_VISITOR.visit(element);
    }

    public static Optional<DeclaredType> maybeDeclared(TypeMirror type) {
        return (Optional)DECLARED_TYPE_VISITOR.visit(type);
    }

    public static Optional<TypeVariable> maybeVariable(TypeMirror type) {
        return (Optional)TYPE_VARIABLE_VISITOR.visit(type);
    }

    public static Optional<TypeElement> maybeAsTypeElement(TypeMirror type) {
        Optional<DeclaredType> declaredType = ModelUtils.maybeDeclared(type);
        if (declaredType.isPresent()) {
            return ModelUtils.maybeType(declaredType.get().asElement());
        }
        return Optional.empty();
    }

    public static TypeElement asElement(DeclaredType type) {
        return ModelUtils.maybeType(type.asElement()).get();
    }

    public static Optional<TypeMirror> maybeUnbox(TypeMirror mirror, Types types) {
        try {
            return Optional.of(types.unboxedType(mirror));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static Optional<ExecutableElement> override(TypeElement type, Types types, String methodName, TypeMirror ... params) {
        return ElementFilter.methodsIn(type.getEnclosedElements()).stream().filter(method -> ModelUtils.signatureMatches(method, types, methodName, params)).findAny();
    }

    public static Optional<ExecutableElement> override(DeclaredType type, Types types, String methodName, TypeMirror ... params) {
        return ModelUtils.override(ModelUtils.asElement(type), types, methodName, params);
    }

    public static boolean overrides(TypeElement type, Types types, String methodName, TypeMirror ... params) {
        return ModelUtils.override(type, types, methodName, params).isPresent();
    }

    public static boolean overrides(DeclaredType type, Types types, String methodName, TypeMirror ... params) {
        return ModelUtils.overrides(ModelUtils.asElement(type), types, methodName, params);
    }

    public static boolean needsSafeVarargs(TypeMirror elementType) {
        return elementType.accept(new SimpleTypeVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitDeclared(DeclaredType t, Void p) {
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    if (ModelUtils.isPlainWildcard(typeMirror)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitTypeVariable(TypeVariable t, Void p) {
                return true;
            }

            @Override
            protected Boolean defaultAction(TypeMirror e, Void p) {
                return false;
            }

            @Override
            public Boolean visitUnknown(TypeMirror t, Void p) {
                return false;
            }
        }, null);
    }

    public static Set<ExecutableElement> only(Modifier modifier, Set<ExecutableElement> methods) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (ExecutableElement method : methods) {
            if (!method.getModifiers().contains((Object)modifier)) continue;
            result.add(method);
        }
        return result.build();
    }

    private static boolean isPlainWildcard(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitWildcard(WildcardType t, Void p) {
                return t.getExtendsBound() == null && t.getSuperBound() == null;
            }

            @Override
            protected Boolean defaultAction(TypeMirror e, Void p) {
                return false;
            }

            @Override
            public Boolean visitUnknown(TypeMirror t, Void p) {
                return false;
            }
        }, null);
    }

    private static boolean signatureMatches(ExecutableElement method, Types types, String name, TypeMirror ... params) {
        if (!method.getSimpleName().contentEquals(name)) {
            return false;
        }
        if (method.getParameters().size() != params.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            TypeMirror actual;
            TypeMirror expected = types.erasure(params[i]);
            if (types.isSameType(expected, actual = types.erasure(method.getParameters().get(i).asType()))) continue;
            return false;
        }
        return true;
    }

    public static TypeMirror getReturnType(TypeElement type, ExecutableElement method, Types types) {
        return ModelUtils.getReturnType((DeclaredType)type.asType(), method, types);
    }

    public static TypeMirror getReturnType(DeclaredType type, ExecutableElement method, Types types) {
        try {
            ExecutableType executableType = (ExecutableType)types.asMemberOf(type, method);
            return executableType.getReturnType();
        }
        catch (IllegalArgumentException e) {
            return method.getReturnType();
        }
    }

    public static TypeMirror upperBound(Elements elements, TypeMirror type) {
        WildcardType wildcard;
        if (type.getKind() == TypeKind.WILDCARD && (type = (wildcard = (WildcardType)type).getExtendsBound()) == null) {
            type = elements.getTypeElement(Object.class.getName()).asType();
        }
        return type;
    }

    public static boolean erasesToAnyOf(DeclaredType type, QualifiedName ... possibilities) {
        if (type == null) {
            return false;
        }
        String erasedType = type.asElement().toString();
        for (QualifiedName possibility : possibilities) {
            if (!Shading.unshadedName(possibility.toString()).equals(erasedType)) continue;
            return true;
        }
        return false;
    }

    public static boolean erasesToAnyOf(DeclaredType type, Class<?> ... possibilities) {
        if (type == null) {
            return false;
        }
        String erasedType = type.asElement().toString();
        for (Class<?> possibility : possibilities) {
            if (!Shading.unshadedName(possibility.getName()).equals(erasedType)) continue;
            return true;
        }
        return false;
    }
}

