/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.WeightedRandomSelection;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieNode;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.net.NetUtils;
import org.apache.bookkeeper.net.NetworkTopology;
import org.apache.bookkeeper.net.NetworkTopologyImpl;
import org.apache.bookkeeper.net.Node;
import org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TopologyAwareEnsemblePlacementPolicy
implements ITopologyAwareEnsemblePlacementPolicy<BookieNode> {
    static final Logger LOG = LoggerFactory.getLogger(TopologyAwareEnsemblePlacementPolicy.class);
    public static final String REPP_DNS_RESOLVER_CLASS = "reppDnsResolverClass";
    protected final Map<BookieId, BookieNode> knownBookies = new HashMap<BookieId, BookieNode>();
    protected final Map<BookieId, BookieNode> historyBookies = new HashMap<BookieId, BookieNode>();
    protected final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected Map<BookieNode, WeightedRandomSelection.WeightedObject> bookieInfoMap = new HashMap<BookieNode, WeightedRandomSelection.WeightedObject>();
    protected ImmutableSet<BookieId> readOnlyBookies = ImmutableSet.of();
    boolean isWeighted;
    protected WeightedRandomSelection<BookieNode> weightedSelection;
    protected NetworkTopology topology;
    protected DNSToSwitchMapping dnsResolver;
    protected BookieAddressResolver bookieAddressResolver;
    @StatsDoc(name="BOOKIES_JOINED", help="The distribution of number of bookies joined the cluster on each network topology change")
    protected OpStatsLogger bookiesJoinedCounter = null;
    @StatsDoc(name="BOOKIES_LEFT", help="The distribution of number of bookies left the cluster on each network topology change")
    protected OpStatsLogger bookiesLeftCounter = null;

    TopologyAwareEnsemblePlacementPolicy() {
    }

    static Set<String> getNetworkLocations(Set<Node> bookieNodes) {
        HashSet<String> networkLocs = new HashSet<String>();
        for (Node bookieNode : bookieNodes) {
            networkLocs.add(bookieNode.getNetworkLocation());
        }
        return networkLocs;
    }

    static void shuffleWithMask(DistributionSchedule.WriteSet writeSet, int mask, int bits) {
        int i;
        int first = -1;
        int last = -1;
        for (i = 0; i < writeSet.size(); ++i) {
            if ((writeSet.get(i) & bits) != mask) continue;
            if (first == -1) {
                first = i;
            }
            last = i;
        }
        if (first != -1) {
            for (i = last + 1; i > first; --i) {
                int swapWith = ThreadLocalRandom.current().nextInt(i);
                writeSet.set(swapWith, writeSet.set(i, writeSet.get(swapWith)));
            }
        }
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        return writeSet;
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadLACSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        DistributionSchedule.WriteSet retList = this.reorderReadSequence(ensemble, bookiesHealthInfo, writeSet);
        retList.addMissingIndices(ensemble.size());
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BookieId> onClusterChanged(Set<BookieId> writableBookies, Set<BookieId> readOnlyBookies) {
        this.rwLock.writeLock().lock();
        try {
            Set<BookieId> oldBookieSet = this.knownBookies.keySet();
            ImmutableSet leftBookies = Sets.difference(oldBookieSet, writableBookies).immutableCopy();
            ImmutableSet joinedBookies = Sets.difference(writableBookies, oldBookieSet).immutableCopy();
            ImmutableSet deadBookies = Sets.difference((Set)leftBookies, readOnlyBookies).immutableCopy();
            LOG.debug("Cluster changed : left bookies are {}, joined bookies are {}, while dead bookies are {}.", new Object[]{leftBookies, joinedBookies, deadBookies});
            this.handleBookiesThatLeft((Set<BookieId>)leftBookies);
            this.handleBookiesThatJoined((Set<BookieId>)joinedBookies);
            if (this.isWeighted && (leftBookies.size() > 0 || joinedBookies.size() > 0)) {
                this.weightedSelection.updateMap(this.bookieInfoMap);
            }
            if (!readOnlyBookies.isEmpty()) {
                this.readOnlyBookies = ImmutableSet.copyOf(readOnlyBookies);
            }
            ImmutableSet immutableSet = deadBookies;
            return immutableSet;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void handleBookiesThatLeft(Set<BookieId> leftBookies) {
        for (BookieId addr : leftBookies) {
            try {
                BookieNode node = this.knownBookies.remove(addr);
                if (null == node) continue;
                this.topology.remove(node);
                if (this.isWeighted) {
                    this.bookieInfoMap.remove(node);
                }
                this.bookiesLeftCounter.registerSuccessfulValue(1L);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Cluster changed : bookie {} left from cluster.", (Object)addr);
            }
            catch (Throwable t) {
                LOG.error("Unexpected exception while handling leaving bookie {}", (Object)addr, (Object)t);
                if (this.bookiesLeftCounter == null) continue;
                this.bookiesLeftCounter.registerFailedValue(1L);
            }
        }
    }

    @Override
    public void handleBookiesThatJoined(Set<BookieId> joinedBookies) {
        for (BookieId addr : joinedBookies) {
            try {
                BookieNode node = this.createBookieNode(addr);
                this.topology.add(node);
                this.knownBookies.put(addr, node);
                this.historyBookies.put(addr, node);
                if (this.isWeighted) {
                    this.bookieInfoMap.putIfAbsent(node, new BookieInfoReader.BookieInfo());
                }
                this.bookiesJoinedCounter.registerSuccessfulValue(1L);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Cluster changed : bookie {} joined the cluster.", (Object)addr);
            }
            catch (Throwable t) {
                LOG.error("Unexpected exception while handling joining bookie {}", (Object)addr, (Object)t);
                this.bookiesJoinedCounter.registerFailedValue(1L);
            }
        }
    }

    @Override
    public void onBookieRackChange(List<BookieId> bookieAddressList) {
        this.rwLock.writeLock().lock();
        try {
            bookieAddressList.forEach(bookieAddress -> {
                try {
                    BookieNode newNode;
                    BookieNode node = this.knownBookies.get(bookieAddress);
                    if (node != null && !(newNode = this.createBookieNode((BookieId)bookieAddress)).getNetworkLocation().equals(node.getNetworkLocation())) {
                        this.topology.remove(node);
                        this.topology.add(newNode);
                        this.knownBookies.put((BookieId)bookieAddress, newNode);
                        this.historyBookies.put((BookieId)bookieAddress, newNode);
                    }
                }
                catch (IllegalArgumentException | NetworkTopologyImpl.InvalidTopologyException e) {
                    LOG.error("Failed to update bookie rack info: {} ", bookieAddress, (Object)e);
                }
            });
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBookieInfo(Map<BookieId, BookieInfoReader.BookieInfo> bookieInfoMap) {
        if (!this.isWeighted) {
            LOG.info("bookieFreeDiskInfo callback called even without weighted placement policy being used.");
            return;
        }
        this.rwLock.writeLock().lock();
        try {
            ArrayList<BookieNode> allBookies = new ArrayList<BookieNode>(this.knownBookies.values());
            HashMap<BookieNode, WeightedRandomSelection.WeightedObject> map = new HashMap<BookieNode, WeightedRandomSelection.WeightedObject>();
            for (BookieNode bookie : allBookies) {
                if (bookieInfoMap.containsKey(bookie.getAddr())) {
                    map.put(bookie, bookieInfoMap.get(bookie.getAddr()));
                    continue;
                }
                map.put(bookie, new BookieInfoReader.BookieInfo());
            }
            this.bookieInfoMap = map;
            this.weightedSelection.updateMap(this.bookieInfoMap);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    protected BookieNode createBookieNode(BookieId addr) {
        return new BookieNode(addr, this.resolveNetworkLocation(addr));
    }

    protected BookieNode createDummyLocalBookieNode(String hostname) {
        return new BookieNode(BookieSocketAddress.createDummyBookieIdForHostname(hostname), NetUtils.resolveNetworkLocation(this.dnsResolver, new BookieSocketAddress(hostname, 0)));
    }

    protected String resolveNetworkLocation(BookieId addr) {
        try {
            return NetUtils.resolveNetworkLocation(this.dnsResolver, this.bookieAddressResolver.resolve(addr));
        }
        catch (BookieAddressResolver.BookieIdNotResolvedException err) {
            BookieNode historyBookie = this.historyBookies.get(addr);
            if (null != historyBookie) {
                return historyBookie.getNetworkLocation();
            }
            LOG.error("Cannot resolve bookieId {} to a network address, resolving as {}", new Object[]{addr, "/default-region/default-rack", err});
            return "/default-region/default-rack";
        }
    }

    protected Set<Node> convertBookiesToNodes(Collection<BookieId> excludeBookies) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (BookieId addr : excludeBookies) {
            BookieNode bn = this.knownBookies.get(addr);
            if (null == bn) {
                bn = this.createBookieNode(addr);
            }
            nodes.add(bn);
        }
        return nodes;
    }

    static class DNSResolverDecorator
    implements DNSToSwitchMapping {
        final Supplier<String> defaultRackSupplier;
        final DNSToSwitchMapping resolver;
        @StatsDoc(name="FAILED_TO_RESOLVE_NETWORK_LOCATION_COUNTER", help="total number of times Resolver failed to resolve rack information of a node")
        final Counter failedToResolveNetworkLocationCounter;

        DNSResolverDecorator(DNSToSwitchMapping resolver, Supplier<String> defaultRackSupplier, Counter failedToResolveNetworkLocationCounter) {
            Preconditions.checkNotNull((Object)resolver, (Object)"Resolver cannot be null");
            Preconditions.checkNotNull(defaultRackSupplier, (Object)"defaultRackSupplier should not be null");
            this.defaultRackSupplier = defaultRackSupplier;
            this.resolver = resolver;
            this.failedToResolveNetworkLocationCounter = failedToResolveNetworkLocationCounter;
        }

        @Override
        public void setBookieAddressResolver(BookieAddressResolver bookieAddressResolver) {
            this.resolver.setBookieAddressResolver(bookieAddressResolver);
        }

        @Override
        public List<String> resolve(List<String> names) {
            if (names == null) {
                return Collections.emptyList();
            }
            String defaultRack = this.defaultRackSupplier.get();
            Preconditions.checkNotNull((Object)defaultRack, (Object)"Default rack cannot be null");
            List<String> rNames = this.resolver.resolve(names);
            if (rNames != null && rNames.size() == names.size()) {
                for (int i = 0; i < rNames.size(); ++i) {
                    if (rNames.get(i) != null) continue;
                    LOG.warn("Failed to resolve network location for {}, using default rack for it : {}.", (Object)names.get(i), (Object)defaultRack);
                    this.failedToResolveNetworkLocationCounter.inc();
                    rNames.set(i, defaultRack);
                }
                return rNames;
            }
            LOG.warn("Failed to resolve network location for {}, using default rack for them : {}.", names, (Object)defaultRack);
            rNames = new ArrayList<String>(names.size());
            for (int i = 0; i < names.size(); ++i) {
                this.failedToResolveNetworkLocationCounter.inc();
                rNames.add(defaultRack);
            }
            return rNames;
        }

        @Override
        public boolean useHostName() {
            return this.resolver.useHostName();
        }

        @Override
        public void reloadCachedMappings() {
            this.resolver.reloadCachedMappings();
        }
    }

    static class DefaultResolver
    implements DNSToSwitchMapping {
        final Supplier<String> defaultRackSupplier;

        public DefaultResolver(Supplier<String> defaultRackSupplier) {
            Preconditions.checkNotNull(defaultRackSupplier, (Object)"defaultRackSupplier should not be null");
            this.defaultRackSupplier = defaultRackSupplier;
        }

        @Override
        public List<String> resolve(List<String> names) {
            ArrayList<String> rNames = new ArrayList<String>(names.size());
            for (String name : names) {
                String defaultRack = this.defaultRackSupplier.get();
                Preconditions.checkNotNull((Object)defaultRack, (Object)"defaultRack cannot be null");
                rNames.add(defaultRack);
            }
            return rNames;
        }

        @Override
        public void reloadCachedMappings() {
        }
    }

    protected static class RRTopologyAwareCoverageEnsemble
    implements ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode>,
    ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> {
        final int distanceFromLeaves;
        final int ensembleSize;
        final int writeQuorumSize;
        final int ackQuorumSize;
        final int minRacksOrRegionsForDurability;
        final int minNumRacksPerWriteQuorum;
        final List<BookieNode> chosenNodes;
        final Set<String> racksOrRegions;
        private final CoverageSet[] quorums;
        final ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> parentPredicate;
        final ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> parentEnsemble;

        protected RRTopologyAwareCoverageEnsemble(RRTopologyAwareCoverageEnsemble that) {
            this.distanceFromLeaves = that.distanceFromLeaves;
            this.ensembleSize = that.ensembleSize;
            this.writeQuorumSize = that.writeQuorumSize;
            this.ackQuorumSize = that.ackQuorumSize;
            this.chosenNodes = Lists.newArrayList(that.chosenNodes);
            this.quorums = new CoverageSet[that.quorums.length];
            for (int i = 0; i < that.quorums.length; ++i) {
                this.quorums[i] = null != that.quorums[i] ? that.quorums[i].duplicate() : null;
            }
            this.parentPredicate = that.parentPredicate;
            this.parentEnsemble = that.parentEnsemble;
            this.racksOrRegions = null != that.racksOrRegions ? new HashSet<String>(that.racksOrRegions) : null;
            this.minRacksOrRegionsForDurability = that.minRacksOrRegionsForDurability;
            this.minNumRacksPerWriteQuorum = that.minNumRacksPerWriteQuorum;
        }

        protected RRTopologyAwareCoverageEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, int distanceFromLeaves, Set<String> racksOrRegions, int minRacksOrRegionsForDurability, int minNumRacksPerWriteQuorum) {
            this(ensembleSize, writeQuorumSize, ackQuorumSize, distanceFromLeaves, null, null, racksOrRegions, minRacksOrRegionsForDurability, minNumRacksPerWriteQuorum);
        }

        protected RRTopologyAwareCoverageEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, int distanceFromLeaves, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> parentPredicate, int minNumRacksPerWriteQuorum) {
            this(ensembleSize, writeQuorumSize, ackQuorumSize, distanceFromLeaves, parentEnsemble, parentPredicate, null, 0, minNumRacksPerWriteQuorum);
        }

        protected RRTopologyAwareCoverageEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, int distanceFromLeaves, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> parentPredicate, Set<String> racksOrRegions, int minRacksOrRegionsForDurability, int minNumRacksPerWriteQuorum) {
            this.ensembleSize = ensembleSize;
            this.writeQuorumSize = writeQuorumSize;
            this.ackQuorumSize = ackQuorumSize;
            this.distanceFromLeaves = distanceFromLeaves;
            this.chosenNodes = new ArrayList<BookieNode>(ensembleSize);
            this.quorums = minRacksOrRegionsForDurability > 0 ? new RackOrRegionDurabilityCoverageSet[ensembleSize] : new RackQuorumCoverageSet[ensembleSize];
            this.parentEnsemble = parentEnsemble;
            this.parentPredicate = parentPredicate;
            this.racksOrRegions = racksOrRegions;
            this.minRacksOrRegionsForDurability = minRacksOrRegionsForDurability;
            this.minNumRacksPerWriteQuorum = minNumRacksPerWriteQuorum;
        }

        @Override
        public boolean apply(BookieNode candidate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble) {
            if (ensemble != this) {
                return false;
            }
            if (this.chosenNodes.contains(candidate)) {
                return false;
            }
            if (this.ensembleSize == this.writeQuorumSize && this.minRacksOrRegionsForDurability > 0) {
                if (null == this.quorums[0]) {
                    this.quorums[0] = new RackOrRegionDurabilityCoverageSet();
                }
                if (!this.quorums[0].apply(candidate)) {
                    return false;
                }
            } else {
                int startPos;
                int candidatePos = this.chosenNodes.size();
                for (int i = startPos = candidatePos - this.writeQuorumSize + 1; i <= candidatePos; ++i) {
                    int idx = (i + this.ensembleSize) % this.ensembleSize;
                    if (null == this.quorums[idx]) {
                        this.quorums[idx] = this.minRacksOrRegionsForDurability > 0 ? new RackOrRegionDurabilityCoverageSet() : new RackQuorumCoverageSet(this.minNumRacksPerWriteQuorum);
                    }
                    if (this.quorums[idx].apply(candidate)) continue;
                    return false;
                }
            }
            return null == this.parentPredicate || this.parentPredicate.apply(candidate, this.parentEnsemble);
        }

        @Override
        public boolean addNode(BookieNode node) {
            if (this.chosenNodes.contains(node)) {
                return false;
            }
            if (this.ensembleSize == this.writeQuorumSize && this.minRacksOrRegionsForDurability > 0) {
                if (null == this.quorums[0]) {
                    this.quorums[0] = new RackOrRegionDurabilityCoverageSet();
                }
                this.quorums[0].addBookie(node);
            } else {
                int startPos;
                int candidatePos = this.chosenNodes.size();
                for (int i = startPos = candidatePos - this.writeQuorumSize + 1; i <= candidatePos; ++i) {
                    int idx = (i + this.ensembleSize) % this.ensembleSize;
                    if (null == this.quorums[idx]) {
                        this.quorums[idx] = this.minRacksOrRegionsForDurability > 0 ? new RackOrRegionDurabilityCoverageSet() : new RackQuorumCoverageSet(this.minNumRacksPerWriteQuorum);
                    }
                    this.quorums[idx].addBookie(node);
                }
            }
            this.chosenNodes.add(node);
            return null == this.parentEnsemble || this.parentEnsemble.addNode(node);
        }

        @Override
        public List<BookieId> toList() {
            ArrayList<BookieId> addresses = new ArrayList<BookieId>(this.ensembleSize);
            for (BookieNode bn : this.chosenNodes) {
                addresses.add(bn.getAddr());
            }
            return addresses;
        }

        @Override
        public boolean validate() {
            HashSet<BookieId> addresses = new HashSet<BookieId>(this.ensembleSize);
            HashSet<String> racksOrRegions = new HashSet<String>();
            for (BookieNode bn : this.chosenNodes) {
                if (addresses.contains(bn.getAddr())) {
                    return false;
                }
                addresses.add(bn.getAddr());
                racksOrRegions.add(bn.getNetworkLocation(this.distanceFromLeaves));
            }
            return this.minRacksOrRegionsForDurability == 0 || racksOrRegions.size() >= this.minRacksOrRegionsForDurability;
        }

        public String toString() {
            return this.chosenNodes.toString();
        }

        protected class RackOrRegionDurabilityCoverageSet
        implements CoverageSet {
            HashMap<String, Integer> allocationToRacksOrRegions = new HashMap();

            RackOrRegionDurabilityCoverageSet() {
                for (String rackOrRegion : RRTopologyAwareCoverageEnsemble.this.racksOrRegions) {
                    this.allocationToRacksOrRegions.put(rackOrRegion, 0);
                }
            }

            @Override
            public RackOrRegionDurabilityCoverageSet duplicate() {
                RackOrRegionDurabilityCoverageSet ret = new RackOrRegionDurabilityCoverageSet();
                ret.allocationToRacksOrRegions = Maps.newHashMap(this.allocationToRacksOrRegions);
                return ret;
            }

            private boolean checkSumOfSubsetWithinLimit(Set<String> includedRacksOrRegions, Set<String> remainingRacksOrRegions, int subsetSize, int maxAllowedSum) {
                if (remainingRacksOrRegions.isEmpty() || subsetSize <= 0) {
                    if (maxAllowedSum < 0 && LOG.isTraceEnabled()) {
                        LOG.trace("CHECK FAILED: RacksOrRegions Included {} Remaining {}, subsetSize {}, maxAllowedSum {}", new Object[]{includedRacksOrRegions, remainingRacksOrRegions, subsetSize, maxAllowedSum});
                    }
                    return maxAllowedSum >= 0;
                }
                for (String rackOrRegion : remainingRacksOrRegions) {
                    Integer currentAllocation = this.allocationToRacksOrRegions.get(rackOrRegion);
                    if (currentAllocation == null) {
                        this.allocationToRacksOrRegions.put(rackOrRegion, 0);
                        currentAllocation = 0;
                    }
                    if (currentAllocation > maxAllowedSum) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("CHECK FAILED: RacksOrRegions Included {} Candidate {}, subsetSize {}, maxAllowedSum {}", new Object[]{includedRacksOrRegions, rackOrRegion, subsetSize, maxAllowedSum});
                        }
                        return false;
                    }
                    HashSet<String> remainingElements = new HashSet<String>(remainingRacksOrRegions);
                    HashSet<String> includedElements = new HashSet<String>(includedRacksOrRegions);
                    includedElements.add(rackOrRegion);
                    remainingElements.remove(rackOrRegion);
                    if (this.checkSumOfSubsetWithinLimit(includedElements, remainingElements, subsetSize - 1, maxAllowedSum - currentAllocation)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean apply(BookieNode candidate) {
                if (RRTopologyAwareCoverageEnsemble.this.minRacksOrRegionsForDurability <= 1) {
                    return true;
                }
                String candidateRackOrRegion = candidate.getNetworkLocation(RRTopologyAwareCoverageEnsemble.this.distanceFromLeaves);
                candidateRackOrRegion = candidateRackOrRegion.startsWith("/") ? candidateRackOrRegion.substring(1) : candidateRackOrRegion;
                HashSet<String> remainingRacksOrRegions = new HashSet<String>(RRTopologyAwareCoverageEnsemble.this.racksOrRegions);
                remainingRacksOrRegions.remove(candidateRackOrRegion);
                HashSet<String> includedRacksOrRegions = new HashSet<String>();
                includedRacksOrRegions.add(candidateRackOrRegion);
                Integer currentAllocation = this.allocationToRacksOrRegions.get(candidateRackOrRegion);
                if (currentAllocation == null) {
                    LOG.info("Detected a region that was not initialized {}", (Object)candidateRackOrRegion);
                    if (candidateRackOrRegion.equals("/default-region")) {
                        LOG.error("Failed to resolve network location {}", (Object)candidate);
                    } else if (!RRTopologyAwareCoverageEnsemble.this.racksOrRegions.contains(candidateRackOrRegion)) {
                        LOG.error("Unknown region detected {}", (Object)candidateRackOrRegion);
                    }
                    this.allocationToRacksOrRegions.put(candidateRackOrRegion, 0);
                    currentAllocation = 0;
                }
                int inclusiveLimit = RRTopologyAwareCoverageEnsemble.this.ackQuorumSize - 1 - (currentAllocation + 1);
                return this.checkSumOfSubsetWithinLimit(includedRacksOrRegions, remainingRacksOrRegions, RRTopologyAwareCoverageEnsemble.this.minRacksOrRegionsForDurability - 2, inclusiveLimit);
            }

            @Override
            public void addBookie(BookieNode candidate) {
                String candidateRackOrRegion = candidate.getNetworkLocation(RRTopologyAwareCoverageEnsemble.this.distanceFromLeaves);
                candidateRackOrRegion = candidateRackOrRegion.startsWith("/") ? candidateRackOrRegion.substring(1) : candidateRackOrRegion;
                int oldCount = 0;
                if (null != this.allocationToRacksOrRegions.get(candidateRackOrRegion)) {
                    oldCount = this.allocationToRacksOrRegions.get(candidateRackOrRegion);
                }
                this.allocationToRacksOrRegions.put(candidateRackOrRegion, oldCount + 1);
            }
        }

        protected class RackQuorumCoverageSet
        implements CoverageSet {
            HashSet<String> racksOrRegionsInQuorum = new HashSet();
            int seenBookies = 0;
            private final int minNumRacksPerWriteQuorum;

            protected RackQuorumCoverageSet(int minNumRacksPerWriteQuorum) {
                this.minNumRacksPerWriteQuorum = Math.min(RRTopologyAwareCoverageEnsemble.this.writeQuorumSize, minNumRacksPerWriteQuorum);
            }

            @Override
            public boolean apply(BookieNode candidate) {
                if (RRTopologyAwareCoverageEnsemble.this.writeQuorumSize < 2) {
                    return true;
                }
                if (this.seenBookies + this.minNumRacksPerWriteQuorum - 1 >= RRTopologyAwareCoverageEnsemble.this.writeQuorumSize) {
                    int numRacks = this.racksOrRegionsInQuorum.size();
                    if (!this.racksOrRegionsInQuorum.contains(candidate.getNetworkLocation(RRTopologyAwareCoverageEnsemble.this.distanceFromLeaves))) {
                        ++numRacks;
                    }
                    return numRacks >= this.minNumRacksPerWriteQuorum || RRTopologyAwareCoverageEnsemble.this.writeQuorumSize - this.seenBookies - 1 >= this.minNumRacksPerWriteQuorum - numRacks;
                }
                return true;
            }

            @Override
            public void addBookie(BookieNode candidate) {
                ++this.seenBookies;
                this.racksOrRegionsInQuorum.add(candidate.getNetworkLocation(RRTopologyAwareCoverageEnsemble.this.distanceFromLeaves));
            }

            @Override
            public RackQuorumCoverageSet duplicate() {
                RackQuorumCoverageSet ret = new RackQuorumCoverageSet(this.minNumRacksPerWriteQuorum);
                ret.racksOrRegionsInQuorum = Sets.newHashSet(this.racksOrRegionsInQuorum);
                ret.seenBookies = this.seenBookies;
                return ret;
            }
        }

        protected static interface CoverageSet {
            public boolean apply(BookieNode var1);

            public void addBookie(BookieNode var1);

            public CoverageSet duplicate();
        }
    }

    protected static class EnsembleForReplacementWithNoConstraints
    implements ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> {
        public static final EnsembleForReplacementWithNoConstraints INSTANCE = new EnsembleForReplacementWithNoConstraints();
        static final List<BookieId> EMPTY_LIST = new ArrayList<BookieId>(0);

        protected EnsembleForReplacementWithNoConstraints() {
        }

        @Override
        public boolean addNode(BookieNode node) {
            return true;
        }

        @Override
        public List<BookieId> toList() {
            return EMPTY_LIST;
        }

        @Override
        public boolean validate() {
            return true;
        }
    }

    protected static class TruePredicate
    implements ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> {
        public static final TruePredicate INSTANCE = new TruePredicate();

        protected TruePredicate() {
        }

        @Override
        public boolean apply(BookieNode candidate, ITopologyAwareEnsemblePlacementPolicy.Ensemble chosenNodes) {
            return true;
        }
    }
}

