/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.com.google.googlejavaformat.java;

import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import org.inferred.freebuilder.shaded.com.google.common.base.CharMatcher;
import org.inferred.freebuilder.shaded.com.google.common.collect.HashMultimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.Range;
import org.inferred.freebuilder.shaded.com.google.common.collect.RangeMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.TreeRangeMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.TreeRangeSet;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.FormattingError;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.Newlines;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.Formatter;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.FormatterException;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.DocCommentTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.doctree.ReferenceTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.IdentifierTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ImportTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.Tree;
import org.inferred.freebuilder.shaded.org.openjdk.source.util.DocTreePath;
import org.inferred.freebuilder.shaded.org.openjdk.source.util.DocTreePathScanner;
import org.inferred.freebuilder.shaded.org.openjdk.source.util.TreePathScanner;
import org.inferred.freebuilder.shaded.org.openjdk.source.util.TreeScanner;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.api.JavacTrees;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.file.JavacFileManager;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.JavacParser;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.ParserFactory;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.tree.DCTree;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.tree.JCTree;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Context;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Log;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Options;

public class RemoveUnusedImports {
    public static String removeUnusedImports(String contents, JavadocOnlyImports javadocOnlyImports) {
        Context context = new Context();
        JCTree.JCCompilationUnit unit = RemoveUnusedImports.parse(context, contents);
        if (unit == null) {
            return contents;
        }
        UnusedImportScanner scanner = new UnusedImportScanner(JavacTrees.instance(context));
        scanner.scan((Tree)unit, null);
        return RemoveUnusedImports.applyReplacements(contents, RemoveUnusedImports.buildReplacements(contents, unit, scanner.usedNames, scanner.usedInJavadoc, javadocOnlyImports));
    }

    private static JCTree.JCCompilationUnit parse(Context context, final String javaInput) {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        context.put(DiagnosticListener.class, diagnostics);
        Options.instance(context).put("allowStringFolding", "false");
        JavacFileManager fileManager = new JavacFileManager(context, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, ImmutableList.of());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SimpleJavaFileObject source = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return javaInput;
            }
        };
        Log.instance(context).useSource(source);
        ParserFactory parserFactory = ParserFactory.instance(context);
        JavacParser parser = parserFactory.newParser(javaInput, true, true, true);
        JCTree.JCCompilationUnit unit = parser.parseCompilationUnit();
        unit.sourcefile = source;
        Iterable<Diagnostic<? extends JavaFileObject>> errorDiagnostics = Iterables.filter(diagnostics.getDiagnostics(), Formatter.ERROR_DIAGNOSTIC);
        if (!Iterables.isEmpty(errorDiagnostics)) {
            throw FormattingError.fromJavacDiagnostics(errorDiagnostics);
        }
        return unit;
    }

    private static RangeMap<Integer, String> buildReplacements(String contents, JCTree.JCCompilationUnit unit, Set<String> usedNames, Multimap<String, Range<Integer>> usedInJavadoc, JavadocOnlyImports javadocOnlyImports) {
        TreeRangeMap<Integer, String> replacements = TreeRangeMap.create();
        for (JCTree.JCImport importTree : unit.getImports()) {
            String sep;
            String simpleName;
            if (!RemoveUnusedImports.isUnused(unit, usedNames, usedInJavadoc, javadocOnlyImports, importTree, simpleName = RemoveUnusedImports.getSimpleName(importTree))) continue;
            int endPosition = importTree.getEndPosition(unit.endPositions);
            endPosition = Math.max(CharMatcher.isNot(' ').indexIn(contents, endPosition), endPosition);
            if (endPosition + (sep = Newlines.guessLineSeparator(contents)).length() < contents.length() && contents.subSequence(endPosition, endPosition + sep.length()).equals(sep)) {
                endPosition += sep.length();
            }
            replacements.put(Range.closedOpen(importTree.getStartPosition(), endPosition), "");
            if (importTree.isStatic()) continue;
            for (Range<Integer> docRange : usedInJavadoc.get(simpleName)) {
                if (docRange == null) continue;
                String replaceWith = importTree.getQualifiedIdentifier().toString();
                replacements.put(docRange, replaceWith);
            }
        }
        return replacements;
    }

    private static String getSimpleName(JCTree.JCImport importTree) {
        return importTree.getQualifiedIdentifier() instanceof JCTree.JCIdent ? ((JCTree.JCIdent)importTree.getQualifiedIdentifier()).getName().toString() : ((JCTree.JCFieldAccess)importTree.getQualifiedIdentifier()).getIdentifier().toString();
    }

    private static boolean isUnused(JCTree.JCCompilationUnit unit, Set<String> usedNames, Multimap<String, Range<Integer>> usedInJavadoc, JavadocOnlyImports javadocOnlyImports, JCTree.JCImport importTree, String simpleName) {
        if (unit.getPackageName() != null) {
            String qualifier;
            String string = qualifier = importTree.getQualifiedIdentifier() instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)importTree.getQualifiedIdentifier()).getExpression().toString() : null;
            if (unit.getPackageName().toString().equals(qualifier)) {
                return true;
            }
        }
        if (importTree.getQualifiedIdentifier() instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)importTree.getQualifiedIdentifier()).getIdentifier().contentEquals("*")) {
            return false;
        }
        if (usedNames.contains(simpleName)) {
            return false;
        }
        return !usedInJavadoc.containsKey(simpleName) || javadocOnlyImports != JavadocOnlyImports.KEEP;
    }

    private static String applyReplacements(String source, RangeMap<Integer, String> replacements) {
        TreeRangeSet<Integer> fixedRanges = TreeRangeSet.create();
        StringBuilder sb = new StringBuilder(source);
        int offset = 0;
        for (Map.Entry<Range<Integer>, String> replacement : replacements.asMapOfRanges().entrySet()) {
            Range<Integer> range = replacement.getKey();
            String replaceWith = replacement.getValue();
            int start = offset + range.lowerEndpoint();
            int end = offset + range.upperEndpoint();
            sb.replace(start, end, replaceWith);
            if (!replaceWith.isEmpty()) {
                fixedRanges.add(Range.closedOpen(start, end));
            }
            offset += replaceWith.length() - (range.upperEndpoint() - range.lowerEndpoint());
        }
        String result = sb.toString();
        if (!fixedRanges.isEmpty()) {
            try {
                result = new Formatter().formatSource(result, fixedRanges.asRanges());
            }
            catch (FormatterException formatterException) {
                // empty catch block
            }
        }
        return result;
    }

    private static class UnusedImportScanner
    extends TreePathScanner<Void, Void> {
        private final Set<String> usedNames = new LinkedHashSet<String>();
        private final Multimap<String, Range<Integer>> usedInJavadoc = HashMultimap.create();
        final JavacTrees trees;
        final DocTreeScanner docTreeSymbolScanner;

        private UnusedImportScanner(JavacTrees trees) {
            this.trees = trees;
            this.docTreeSymbolScanner = new DocTreeScanner();
        }

        @Override
        public Void visitImport(ImportTree importTree, Void usedSymbols) {
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree tree, Void unused) {
            if (tree == null) {
                return null;
            }
            this.usedNames.add(tree.getName().toString());
            return null;
        }

        @Override
        public Void scan(Tree tree, Void unused) {
            if (tree == null) {
                return null;
            }
            this.scanJavadoc();
            return (Void)super.scan(tree, unused);
        }

        private void scanJavadoc() {
            if (this.getCurrentPath() == null) {
                return;
            }
            DocCommentTree commentTree = this.trees.getDocCommentTree(this.getCurrentPath());
            if (commentTree == null) {
                return;
            }
            this.docTreeSymbolScanner.scan(new DocTreePath(this.getCurrentPath(), commentTree), null);
        }

        class DocTreeScanner
        extends DocTreePathScanner<Void, Void> {
            DocTreeScanner() {
            }

            @Override
            public Void visitIdentifier(org.inferred.freebuilder.shaded.org.openjdk.source.doctree.IdentifierTree node, Void aVoid) {
                return null;
            }

            @Override
            public Void visitReference(ReferenceTree referenceTree, Void unused) {
                DCTree.DCReference reference = (DCTree.DCReference)referenceTree;
                long basePos = reference.getSourcePosition((DCTree.DCDocComment)this.getCurrentPath().getDocComment());
                if (reference.qualifierExpression != null) {
                    new ReferenceScanner(basePos).scan(reference.qualifierExpression, null);
                }
                if (reference.paramTypes != null) {
                    for (JCTree param : reference.paramTypes) {
                        new ReferenceScanner(-1L).scan(param, null);
                    }
                }
                return null;
            }

            private class ReferenceScanner
            extends TreeScanner<Void, Void> {
                private final long basePos;

                public ReferenceScanner(long basePos) {
                    this.basePos = basePos;
                }

                @Override
                public Void visitIdentifier(IdentifierTree node, Void aVoid) {
                    UnusedImportScanner.this.usedInJavadoc.put(node.getName().toString(), this.basePos != -1L ? Range.closedOpen((int)this.basePos, (int)this.basePos + node.getName().length()) : null);
                    return (Void)super.visitIdentifier(node, aVoid);
                }
            }
        }
    }

    public static enum JavadocOnlyImports {
        REMOVE,
        KEEP;

    }
}

