/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class SerializeUtilsTest {
    @Test
    public void testSerializeRequestRequestIsNull() {
        byte[] data = SerializeUtils.serializeRequest(null);
        Assert.assertNull((Object)data);
    }

    @Test
    public void testSerializeRequestRequestHeaderIsNull() {
        Request request = new Request(0L, 0, 0, null, null, 0L);
        byte[] data = SerializeUtils.serializeRequest((Request)request);
        Assert.assertNull((Object)data);
    }

    @Test
    public void testSerializeRequestWithoutTxn() throws IOException {
        TxnHeader header = (TxnHeader)Mockito.mock(TxnHeader.class);
        ((TxnHeader)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("header", "test");
                return null;
            }
        }).when((Object)header)).serialize((OutputArchive)ArgumentMatchers.any(OutputArchive.class), ArgumentMatchers.anyString());
        Request request = new Request(1L, 2, 3, header, null, 4L);
        byte[] data = SerializeUtils.serializeRequest((Request)request);
        Assert.assertNotNull((Object)data);
        ((TxnHeader)Mockito.verify((Object)header)).serialize((OutputArchive)ArgumentMatchers.any(OutputArchive.class), (String)ArgumentMatchers.eq((Object)"hdr"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
        boa.writeString("header", "test");
        baos.close();
        Assert.assertArrayEquals((byte[])baos.toByteArray(), (byte[])data);
    }

    @Test
    public void testSerializeRequestWithTxn() throws IOException {
        TxnHeader header = (TxnHeader)Mockito.mock(TxnHeader.class);
        ((TxnHeader)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("header", "test");
                return null;
            }
        }).when((Object)header)).serialize((OutputArchive)ArgumentMatchers.any(OutputArchive.class), ArgumentMatchers.anyString());
        Record txn = (Record)Mockito.mock(Record.class);
        ((Record)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("record", "test");
                return null;
            }
        }).when((Object)txn)).serialize((OutputArchive)ArgumentMatchers.any(OutputArchive.class), ArgumentMatchers.anyString());
        Request request = new Request(1L, 2, 3, header, txn, 4L);
        byte[] data = SerializeUtils.serializeRequest((Request)request);
        Assert.assertNotNull((Object)data);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{header, txn});
        ((TxnHeader)inOrder.verify((Object)header)).serialize((OutputArchive)ArgumentMatchers.any(OutputArchive.class), (String)ArgumentMatchers.eq((Object)"hdr"));
        ((Record)inOrder.verify((Object)txn)).serialize((OutputArchive)ArgumentMatchers.any(OutputArchive.class), (String)ArgumentMatchers.eq((Object)"txn"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
        boa.writeString("header", "test");
        boa.writeString("record", "test");
        baos.close();
        Assert.assertArrayEquals((byte[])baos.toByteArray(), (byte[])data);
    }
}

