/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.impl;

import com.google.common.base.Preconditions;
import io.netty.util.Recycler;
import java.util.Iterator;
import java.util.List;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerEntry;

public class LedgerEntriesImpl
implements LedgerEntries {
    private List<LedgerEntry> entries;
    private final Recycler.Handle<LedgerEntriesImpl> recyclerHandle;
    private static final Recycler<LedgerEntriesImpl> RECYCLER = new Recycler<LedgerEntriesImpl>(){

        protected LedgerEntriesImpl newObject(Recycler.Handle<LedgerEntriesImpl> handle) {
            return new LedgerEntriesImpl(handle);
        }
    };

    private LedgerEntriesImpl(Recycler.Handle<LedgerEntriesImpl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    private void recycle() {
        this.releaseByteBuf();
        this.recyclerHandle.recycle((Object)this);
    }

    private void releaseByteBuf() {
        if (this.entries != null) {
            this.entries.forEach(LedgerEntry::close);
            this.entries.clear();
            this.entries = null;
        }
    }

    public static LedgerEntriesImpl create(List<LedgerEntry> entries) {
        Preconditions.checkArgument((!entries.isEmpty() ? 1 : 0) != 0, (Object)"entries for create should not be empty.");
        LedgerEntriesImpl ledgerEntries = (LedgerEntriesImpl)RECYCLER.get();
        ledgerEntries.entries = entries;
        return ledgerEntries;
    }

    @Override
    public LedgerEntry getEntry(long entryId) {
        Preconditions.checkNotNull(this.entries, (Object)"entries has been recycled");
        long firstId = this.entries.get(0).getEntryId();
        long lastId = this.entries.get(this.entries.size() - 1).getEntryId();
        if (entryId < firstId || entryId > lastId) {
            throw new IndexOutOfBoundsException("required index: " + entryId + " is out of bounds: [ " + firstId + ", " + lastId + " ].");
        }
        return this.entries.get((int)(entryId - firstId));
    }

    @Override
    public Iterator<LedgerEntry> iterator() {
        Preconditions.checkNotNull(this.entries, (Object)"entries has been recycled");
        return this.entries.iterator();
    }

    @Override
    public void close() {
        this.recycle();
    }
}

