/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NativeIO {
    private static final Logger LOG = LoggerFactory.getLogger(NativeIO.class);
    private static final int POSIX_FADV_DONTNEED = 4;
    private static boolean initialized = false;
    private static boolean fadvisePossible = true;

    public static native int posix_fadvise(int var0, long var1, long var3, int var5) throws LastErrorException;

    private NativeIO() {
    }

    private static Field getFieldByReflection(Class cls, String fieldName) {
        Field field;
        block2: {
            field = null;
            try {
                field = cls.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (Exception e) {
                LOG.warn("Unable to read {} field from {}", (Object)fieldName, (Object)cls.getName());
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return field;
    }

    public static int getSysFileDescriptor(FileDescriptor descriptor) {
        Field field = NativeIO.getFieldByReflection(descriptor.getClass(), "fd");
        try {
            return field.getInt(descriptor);
        }
        catch (Exception e) {
            LOG.warn("Unable to read fd field from java.io.FileDescriptor");
            return -1;
        }
    }

    public static void bestEffortRemoveFromPageCache(int fd, long offset, long len) {
        if (!initialized || !fadvisePossible || fd < 0) {
            return;
        }
        try {
            NativeIO.posix_fadvise(fd, offset, len, 4);
        }
        catch (UnsupportedOperationException uoe) {
            LOG.warn("posix_fadvise is not supported : ", (Throwable)uoe);
            fadvisePossible = false;
        }
        catch (UnsatisfiedLinkError ule) {
            LOG.warn("Unsatisfied Link error: posix_fadvise failed on file descriptor {}, offset {} : ", new Object[]{fd, offset, ule});
            fadvisePossible = false;
        }
        catch (Exception e) {
            LOG.warn("Unknown exception: posix_fadvise failed on file descriptor {}, offset {} : ", new Object[]{fd, offset, e});
        }
    }

    static {
        try {
            Native.register((String)"c");
            initialized = true;
        }
        catch (NoClassDefFoundError e) {
            LOG.info("JNA not found. Native methods will be disabled.");
        }
        catch (UnsatisfiedLinkError e) {
            LOG.info("Unable to link C library. Native methods will be disabled.");
        }
        catch (NoSuchMethodError e) {
            LOG.warn("Obsolete version of JNA present; unable to register C library");
        }
    }
}

