/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.javac.processing;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import javax.lang.model.util.ElementScanner9;

public class JavacRoundEnvironment
implements RoundEnvironment {
    private final boolean processingOver;
    private final boolean errorRaised;
    private final ProcessingEnvironment processingEnv;
    private final Set<? extends Element> rootElements;
    private static final String NOT_AN_ANNOTATION_TYPE = "The argument does not represent an annotation type: ";

    JavacRoundEnvironment(boolean processingOver, boolean errorRaised, Set<? extends Element> rootElements, ProcessingEnvironment processingEnv) {
        this.processingOver = processingOver;
        this.errorRaised = errorRaised;
        this.rootElements = rootElements;
        this.processingEnv = processingEnv;
    }

    public String toString() {
        return String.format("[errorRaised=%b, rootElements=%s, processingOver=%b]", this.errorRaised, this.rootElements, this.processingOver);
    }

    @Override
    public boolean processingOver() {
        return this.processingOver;
    }

    @Override
    public boolean errorRaised() {
        return this.errorRaised;
    }

    @Override
    public Set<? extends Element> getRootElements() {
        return this.rootElements;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(TypeElement a) {
        Set result = Collections.emptySet();
        if (a.getKind() != ElementKind.ANNOTATION_TYPE) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + a);
        }
        AnnotationSetScanner scanner = new AnnotationSetScanner(result);
        for (Element element : this.rootElements) {
            result = (Set)((ElementScanner6)scanner).scan(element, a);
        }
        return result;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> a) {
        if (!a.isAnnotation()) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + a);
        }
        String name = a.getCanonicalName();
        if (name == null) {
            return Collections.emptySet();
        }
        TypeElement annotationType = this.processingEnv.getElementUtils().getTypeElement(name);
        if (annotationType == null) {
            return Collections.emptySet();
        }
        return this.getElementsAnnotatedWith(annotationType);
    }

    private class AnnotationSetScanner
    extends ElementScanner9<Set<Element>, TypeElement> {
        Set<Element> annotatedElements;

        AnnotationSetScanner(Set<Element> defaultSet) {
            super(defaultSet);
            this.annotatedElements = new LinkedHashSet<Element>();
        }

        @Override
        public Set<Element> visitType(TypeElement e, TypeElement p) {
            this.scan(e.getTypeParameters(), p);
            return (Set)super.visitType(e, p);
        }

        @Override
        public Set<Element> visitExecutable(ExecutableElement e, TypeElement p) {
            this.scan(e.getTypeParameters(), p);
            return (Set)super.visitExecutable(e, p);
        }

        @Override
        public Set<Element> scan(Element e, TypeElement p) {
            List<? extends AnnotationMirror> annotationMirrors = JavacRoundEnvironment.this.processingEnv.getElementUtils().getAllAnnotationMirrors(e);
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (!p.equals(annotationMirror.getAnnotationType().asElement())) continue;
                this.annotatedElements.add(e);
            }
            e.accept(this, p);
            return this.annotatedElements;
        }
    }
}

