/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.RequestThrottler;
import org.apache.zookeeper.server.SessionTrackerImpl;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class SessionTrackerTest
extends ZKTestCase {
    private final long sessionId = 339900L;
    private final int sessionTimeout = 3000;
    private FirstProcessor firstProcessor;
    private CountDownLatch latch;

    @Test
    @Timeout(value=20L)
    public void testAddSessionAfterSessionExpiry() throws Exception {
        RequestThrottler.setMaxRequests((int)0);
        ZooKeeperServer zks = this.setupSessionTracker();
        this.latch = new CountDownLatch(1);
        zks.sessionTracker.trackSession(339900L, 3000);
        SessionTrackerImpl sessionTrackerImpl = (SessionTrackerImpl)zks.sessionTracker;
        SessionTrackerImpl.SessionImpl sessionImpl = (SessionTrackerImpl.SessionImpl)sessionTrackerImpl.sessionsById.get(339900L);
        Assertions.assertNotNull((Object)sessionImpl, (String)"Sessionid:339900 doesn't exists in sessiontracker");
        Object sessionOwner = new Object();
        sessionTrackerImpl.checkSession(339900L, sessionOwner);
        this.latch.await(6000L, TimeUnit.MILLISECONDS);
        sessionTrackerImpl.trackSession(339900L, 3000);
        try {
            sessionTrackerImpl.checkSession(339900L, sessionOwner);
            Assertions.fail((String)"Should throw session expiry exception as the session has expired and closed");
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)sessionImpl.isClosing(), (String)"Session didn't expired");
        Assertions.assertFalse((boolean)sessionTrackerImpl.touchSession(339900L, 3000), (String)"Session didn't expired");
        Assertions.assertEquals((int)1, (int)this.firstProcessor.getCountOfCloseSessionReq(), (String)"Duplicate session expiry request has been generated");
    }

    @Test
    @Timeout(value=20L)
    public void testCloseSessionRequestAfterSessionExpiry() throws Exception {
        ZooKeeperServer zks = this.setupSessionTracker();
        this.latch = new CountDownLatch(1);
        zks.sessionTracker.trackSession(339900L, 3000);
        SessionTrackerImpl sessionTrackerImpl = (SessionTrackerImpl)zks.sessionTracker;
        SessionTrackerImpl.SessionImpl sessionImpl = (SessionTrackerImpl.SessionImpl)sessionTrackerImpl.sessionsById.get(339900L);
        Assertions.assertNotNull((Object)sessionImpl, (String)"Sessionid:339900 doesn't exists in sessiontracker");
        Object sessionOwner = new Object();
        sessionTrackerImpl.checkSession(339900L, sessionOwner);
        this.latch.await(6000L, TimeUnit.MILLISECONDS);
        sessionTrackerImpl.removeSession(339900L);
        SessionTrackerImpl.SessionImpl actualSession = (SessionTrackerImpl.SessionImpl)sessionTrackerImpl.sessionsById.get(339900L);
        Assertions.assertNull((Object)actualSession, (String)"Session:339900 still exists after removal");
    }

    private ZooKeeperServer setupSessionTracker() throws IOException {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        zks.setupRequestProcessors();
        this.firstProcessor = new FirstProcessor(zks, null);
        zks.firstProcessor = this.firstProcessor;
        zks.createSessionTracker();
        zks.startSessionTracker();
        zks.startRequestThrottler();
        return zks;
    }

    private class FirstProcessor
    extends PrepRequestProcessor {
        private volatile int countOfCloseSessionReq;

        public FirstProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
            super(zks, nextProcessor);
            this.countOfCloseSessionReq = 0;
        }

        public void processRequest(Request request) {
            if (request.type == -11) {
                ++this.countOfCloseSessionReq;
                SessionTrackerTest.this.latch.countDown();
            }
        }

        int getCountOfCloseSessionReq() {
            return this.countOfCloseSessionReq;
        }
    }
}

